/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.RowSorterEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import tecgraf.javautils.gui.GUIResources;
import tecgraf.javautils.gui.table.DefaultToolTipTableCellRenderer;
import tecgraf.javautils.gui.table.FooterComparatorWrapper;
import tecgraf.javautils.gui.table.FooterModelWrapper;
import tecgraf.javautils.gui.table.FooterRendererWrapper;
import tecgraf.javautils.gui.table.RespectEnabledStateCellRenderer;
import tecgraf.javautils.gui.table.SortableTableListener;
import tecgraf.javautils.gui.table.TecDefaultRowSorter;
import tecgraf.javautils.gui.table.TecTableRowSorter;

public class SortableTable
extends JTable
implements SortableTableListener {
    private boolean pendingColumnsAdjustment = false;
    private int[] columnIndexesForRemainingSpace;
    private boolean toolTipEnabled = false;
    private Map<Integer, TableCellRenderer> originalTableCellRenderers;
    private TecTableRowSorter<TableModel> rowSorter;
    private boolean noSortStateEnabled;
    private boolean useDisabledLook = false;

    public SortableTable() {
        this(true);
    }

    public SortableTable(boolean enableSort) {
        if (enableSort) {
            this.rowSorter = new TecTableRowSorter();
            this.setRowSorter(this.rowSorter);
        }
    }

    public SortableTable(TableModel model) {
        this(model, true);
    }

    public SortableTable(TableModel model, boolean enableSort) {
        this(model, enableSort, new TecTableRowSorter<TableModel>(model));
    }

    public SortableTable(TableModel model, boolean enableSort, TecTableRowSorter<TableModel> sorter, boolean useDisabledLook) {
        super(model);
        this.useDisabledLook = useDisabledLook;
        if (!enableSort) {
            return;
        }
        this.rowSorter = sorter;
        sorter.setModel(model);
        this.setRowSorter(this.rowSorter);
        if (model instanceof FooterModelWrapper) {
            this.rowSorter.setNullComparison(true);
            for (int i = 0; i < this.getColumnCount(); ++i) {
                Comparator<?> actualComp = this.getComparator(i);
                FooterComparatorWrapper compWrapper = new FooterComparatorWrapper(this, actualComp);
                this.addSortableTableListener(compWrapper);
                this.setComparator(i, compWrapper);
            }
        }
        this.sort();
    }

    public SortableTable(TableModel model, boolean enableSort, TecTableRowSorter<TableModel> sorter) {
        this(model, enableSort, sorter, false);
    }

    @Override
    public void setModel(TableModel dataModel) {
        super.setModel(dataModel);
        this.setRowSorter(this.rowSorter);
        if (this.rowSorter != null) {
            this.rowSorter.setModel(dataModel);
        }
    }

    public void setRowFilter(RowFilter<? super TableModel, ? super Integer> filter) {
        this.rowSorter.setRowFilter(filter);
    }

    public final void setToolTipEnabled(boolean enabled) {
        this.toolTipEnabled = enabled;
        if (enabled) {
            this.setDefaultToolTipTableCellRenderer();
        } else {
            this.restoreOriginalTableCellRenderers();
        }
    }

    private void setDefaultToolTipTableCellRenderer() {
        Enumeration<TableColumn> it = this.getColumnModel().getColumns();
        this.originalTableCellRenderers = new HashMap<Integer, TableCellRenderer>();
        while (it.hasMoreElements()) {
            TableColumn column = it.nextElement();
            this.originalTableCellRenderers.put(column.getModelIndex(), column.getCellRenderer());
            column.setCellRenderer(new DefaultToolTipTableCellRenderer());
        }
    }

    private void restoreOriginalTableCellRenderers() {
        if (this.originalTableCellRenderers == null || this.originalTableCellRenderers.size() == 0) {
            return;
        }
        Enumeration<TableColumn> it = this.getColumnModel().getColumns();
        while (it.hasMoreElements()) {
            TableColumn column = it.nextElement();
            TableCellRenderer originalRenderer = this.originalTableCellRenderers.get(column.getModelIndex());
            column.setCellRenderer(originalRenderer);
        }
    }

    public final boolean getToolTipEnabled() {
        return this.toolTipEnabled;
    }

    public void adjustRowHeight() {
        int rowCount = this.getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            this.rowHeight = 0;
            int prefCellHeight = this.getPreferredCellHeight(row);
            if (prefCellHeight > this.rowHeight) {
                this.rowHeight = prefCellHeight;
            }
            this.rowHeight += this.getRowMargin();
            this.setRowHeight(row, this.rowHeight);
        }
    }

    protected int getPreferredCellHeight(int viewRowIndex) {
        int prefRowHeight = 0;
        int colCount = this.getColumnCount();
        for (int c = 0; c < colCount; ++c) {
            TableCellRenderer renderer = this.getCellRenderer(viewRowIndex, c);
            int modelRowIndex = this.convertRowIndexToModel(viewRowIndex);
            boolean isSelected = this.isCellSelected(viewRowIndex, c);
            boolean rowIsLead = this.getSelectionModel().getLeadSelectionIndex() == viewRowIndex;
            boolean colIsLead = this.getColumnModel().getSelectionModel().getLeadSelectionIndex() == c;
            boolean hasFocus = rowIsLead && colIsLead && this.isFocusOwner();
            Component comp = renderer.getTableCellRendererComponent(this, this.getModel().getValueAt(modelRowIndex, c), isSelected, hasFocus, viewRowIndex, c);
            int prefCellHeight = comp.getPreferredSize().height;
            if (prefCellHeight <= prefRowHeight) continue;
            prefRowHeight = prefCellHeight;
        }
        return prefRowHeight;
    }

    public void adjustColumnWidth() {
        this.columnIndexesForRemainingSpace = this.getColumnIndexes();
        if (!this.isDisplayable()) {
            this.pendingColumnsAdjustment = true;
            return;
        }
        this.doAdjustColumnWidths();
    }

    private int[] getColumnIndexes() {
        int[] indexes = new int[this.getColumnCount()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = i;
        }
        return indexes;
    }

    public void adjustColumnWidth(int[] columnIndexes) {
        if (columnIndexes == null || columnIndexes.length == 0) {
            throw new IllegalArgumentException("columnIndexes est\u00e1 vazia");
        }
        for (int i = 0; i < columnIndexes.length; ++i) {
            if (columnIndexes[i] >= 0 && columnIndexes[i] < this.getColumnCount()) continue;
            throw new IllegalArgumentException("columnIndexes[" + i + "]: " + columnIndexes[i]);
        }
        this.columnIndexesForRemainingSpace = columnIndexes;
        if (!this.isDisplayable()) {
            this.pendingColumnsAdjustment = true;
            return;
        }
        this.doAdjustColumnWidths();
    }

    @Override
    public void doLayout() {
        if (this.pendingColumnsAdjustment) {
            this.doAdjustColumnWidths();
        }
        super.doLayout();
    }

    private void doAdjustColumnWidths() {
        this.setPreferredColumnWidthToFit();
        this.setRemainingSpaceToColumns(this.columnIndexesForRemainingSpace);
        this.pendingColumnsAdjustment = false;
    }

    protected void setPreferredColumnWidthToFit() {
        TableColumnModel colModel = this.getColumnModel();
        int colCount = colModel.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            TableColumn column = colModel.getColumn(i);
            int columnWidth = this.getPreferredHeaderWidth(column, i);
            int prefCellWidth = this.getPreferredCellWidth(i);
            if (prefCellWidth > columnWidth) {
                columnWidth = prefCellWidth;
            }
            column.setPreferredWidth(columnWidth += colModel.getColumnMargin() * 2);
        }
    }

    protected int getPreferredHeaderWidth(TableColumn column, int viewColIndex) {
        TableCellRenderer renderer = column.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(this, column.getHeaderValue(), false, false, 0, viewColIndex);
        return comp.getPreferredSize().width;
    }

    protected int getPreferredCellWidth(int viewColIndex) {
        int prefColWidth = 0;
        int rowCount = this.getRowCount();
        for (int r = 0; r < rowCount; ++r) {
            TableCellRenderer renderer = this.getCellRenderer(r, viewColIndex);
            int modelColIndex = this.convertColumnIndexToModel(viewColIndex);
            boolean isSelected = this.isCellSelected(r, viewColIndex);
            boolean rowIsLead = this.getSelectionModel().getLeadSelectionIndex() == r;
            boolean colIsLead = this.getColumnModel().getSelectionModel().getLeadSelectionIndex() == viewColIndex;
            boolean hasFocus = rowIsLead && colIsLead && this.isFocusOwner();
            Component comp = renderer.getTableCellRendererComponent(this, this.getModel().getValueAt(r, modelColIndex), isSelected, hasFocus, r, viewColIndex);
            int prefCellWidth = comp.getPreferredSize().width;
            if (prefCellWidth <= prefColWidth) continue;
            prefColWidth = prefCellWidth;
        }
        return prefColWidth + this.getIntercellSpacing().width * 2;
    }

    protected void setRemainingSpaceToColumns(int[] columnIndexes) {
        TableColumnModel colModel = this.getColumnModel();
        int colCount = colModel.getColumnCount();
        if (colCount == 0) {
            return;
        }
        int totalPrefWidth = 0;
        Enumeration<TableColumn> columns = colModel.getColumns();
        while (columns.hasMoreElements()) {
            TableColumn col = columns.nextElement();
            totalPrefWidth += col.getPreferredWidth();
        }
        int remaining = this.getWidth() - totalPrefWidth;
        if (remaining > 0) {
            int indexesCount = columnIndexes.length;
            int quotient = remaining / indexesCount;
            int modulus = remaining % indexesCount;
            for (int i = 0; i < indexesCount; ++i) {
                int delta = modulus-- > 0 ? quotient + 1 : quotient;
                TableColumn column = colModel.getColumn(columnIndexes[i]);
                column.setPreferredWidth(column.getPreferredWidth() + delta);
            }
        }
    }

    public void adjustSize() {
        this.adjustColumnWidth();
        this.adjustRowHeight();
    }

    public void sort() {
        this.sort(0, SortOrder.ASCENDING);
    }

    public void sort(int initialBaseColumnIndex, SortOrder initialSortOrder) {
        this.sort(new RowSorter.SortKey(initialBaseColumnIndex, initialSortOrder));
    }

    public void sort(RowSorter.SortKey ... sortKeys) {
        if (this.getRowSorter() == null) {
            throw new IllegalStateException("rowSorter == null");
        }
        this.getRowSorter().setSortKeys(Arrays.asList(sortKeys));
    }

    public Comparator<?> getComparator(int colIndex) {
        TecTableRowSorter sorter = (TecTableRowSorter)this.getRowSorter();
        if (sorter == null) {
            return null;
        }
        return sorter.getComparator(colIndex);
    }

    public void setComparator(int colIndex, Comparator<?> comparator) {
        TecTableRowSorter sorter = (TecTableRowSorter)this.getRowSorter();
        if (sorter != null) {
            sorter.setComparator(colIndex, comparator);
        }
    }

    public void setComparators(Comparator<?>[] comparators) {
        if (comparators == null) {
            throw new IllegalArgumentException("comparators == null");
        }
        TecTableRowSorter sorter = (TecTableRowSorter)this.getRowSorter();
        if (sorter != null) {
            for (int colIndex = 0; colIndex < comparators.length; ++colIndex) {
                sorter.setComparator(colIndex, comparators[colIndex]);
            }
        }
    }

    public int getSortedColIndexView() {
        if (this.getRowSorter() == null) {
            return -1;
        }
        List<RowSorter.SortKey> sortKeys = this.getRowSorter().getSortKeys();
        if (sortKeys == null || sortKeys.size() < 1) {
            return -1;
        }
        return this.convertColumnIndexToView(sortKeys.get(0).getColumn());
    }

    public SortOrder getCurrentSortOrder() {
        if (this.getRowSorter() == null) {
            return SortOrder.UNSORTED;
        }
        List<RowSorter.SortKey> sortKeys = this.getRowSorter().getSortKeys();
        if (sortKeys == null || sortKeys.size() < 1) {
            return SortOrder.UNSORTED;
        }
        return sortKeys.get(0).getSortOrder();
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer = super.getCellRenderer(row, column);
        if (this.getModel() instanceof FooterModelWrapper) {
            renderer = new FooterRendererWrapper(renderer, this.useDisabledLook);
        } else if (this.useDisabledLook) {
            renderer = new RespectEnabledStateCellRenderer(renderer);
        }
        return renderer;
    }

    public boolean getNoSortStateEnabled() {
        return this.noSortStateEnabled;
    }

    public void setNoSortStateEnabled(boolean enable) {
        this.noSortStateEnabled = enable;
        RowSorter<? extends TableModel> sorter = this.getRowSorter();
        if (sorter != null && sorter instanceof TecTableRowSorter) {
            ((TecTableRowSorter)sorter).setNoSortEnabled(this.noSortStateEnabled);
        }
    }

    @Override
    public void setRowSorter(RowSorter<? extends TableModel> sorter) {
        super.setRowSorter(sorter);
        if (sorter instanceof TecDefaultRowSorter) {
            ((TecTableRowSorter)sorter).setNoSortEnabled(this.noSortStateEnabled);
        }
    }

    @Override
    public int convertRowIndexToModel(int viewRowIndex) {
        if (viewRowIndex < 0) {
            return -1;
        }
        if (this.getModel() == null) {
            return -1;
        }
        if (viewRowIndex >= this.getModel().getRowCount()) {
            return -1;
        }
        return super.convertRowIndexToModel(viewRowIndex);
    }

    @Override
    public int convertRowIndexToView(int modelRowIndex) {
        if (modelRowIndex < 0) {
            return -1;
        }
        if (this.getModel() == null) {
            return -1;
        }
        if (modelRowIndex >= this.getModel().getRowCount()) {
            return -1;
        }
        return super.convertRowIndexToView(modelRowIndex);
    }

    public void setSortable(int columnIndex, boolean sortable) {
        if (this.rowSorter != null) {
            this.rowSorter.setSortable(columnIndex, sortable);
        }
    }

    public void setUseDisabledLook(boolean useDisabledLook) {
        this.useDisabledLook = useDisabledLook;
    }

    public void addSortableTableListener(SortableTableListener l) {
        this.listenerList.add(SortableTableListener.class, l);
    }

    public void removeSortableTableListener(SortableTableListener l) {
        this.listenerList.remove(SortableTableListener.class, l);
    }

    @Override
    public void sorterChanged(RowSorterEvent e) {
        super.sorterChanged(e);
        if (e.getType().equals((Object)RowSorterEvent.Type.SORTED)) {
            this.tableSorted(this);
        }
    }

    @Override
    public void tableSorted(Object source) {
        this.fireTableSorted();
    }

    private void fireTableSorted() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SortableTableListener.class) continue;
            ((SortableTableListener)listeners[i + 1]).tableSorted(this);
        }
    }

    public JPanel createSearchPanel(String title, String ignoreCaseLabelText, String previousToolTipText, String nextToolTipText, int paddingSize, boolean inLine) {
        return new SearchPanel(title, ignoreCaseLabelText, previousToolTipText, nextToolTipText, paddingSize, inLine);
    }

    public JPanel createSearchPanel(String title, String ignoreCaseLabelText, String previousToolTipText, String nextToolTipText, int paddingSize) {
        return this.createSearchPanel(title, ignoreCaseLabelText, previousToolTipText, nextToolTipText, paddingSize, false);
    }

    private class SearchPanel
    extends JPanel {
        private JTextField searchField;
        private JCheckBox ignoreCaseCheck;
        private String ignoreCaseLabelText;
        private String previousToolTipText;
        private String nextToolTipText;
        private int matchingRowIndex = -1;
        private int lastSearchedColIndexView = -1;
        private static final int SEARCH_TYPE_BACK = -1;
        private static final int SEARCH_TYPE_FORWARD = 1;

        private SearchPanel(String title, String previousToolTipText, String nextToolTipText, int paddingSize, boolean inLine) {
            this(title, null, previousToolTipText, nextToolTipText, paddingSize, inLine);
        }

        private SearchPanel(String title, String ignoreCaseLabelText, String previousToolTipText, String nextToolTipText, int paddingSize, boolean inLine) {
            this.ignoreCaseLabelText = ignoreCaseLabelText;
            this.previousToolTipText = previousToolTipText;
            this.nextToolTipText = nextToolTipText;
            this.searchField = this.createSearchField();
            this.ignoreCaseCheck = this.createIgnoreCaseCheck();
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(0, 0, 0, 0);
            c.fill = 2;
            c.anchor = 10;
            c.insets.set(paddingSize, paddingSize, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            if (inLine) {
                c.weightx = 0.0;
                c.weighty = 0.0;
                this.add((Component)new JLabel(title), c);
                c.gridx = 1;
            }
            c.weightx = 3.0;
            c.weighty = 3.0;
            this.add((Component)this.searchField, c);
            c.insets.set(paddingSize, paddingSize, 0, 0);
            c.fill = 0;
            ++c.gridx;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.add((Component)this.createStepBackButton(), c);
            c.insets.set(paddingSize, paddingSize, 0, paddingSize);
            c.fill = 0;
            ++c.gridx;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.add((Component)this.createStepForwardButton(), c);
            if (this.ignoreCaseCheck != null) {
                c.insets.set(paddingSize, paddingSize, paddingSize, paddingSize);
                c.fill = 1;
                c.gridx = 0;
                c.gridy = 1;
                c.gridwidth = 3;
                c.gridheight = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                this.add((Component)this.ignoreCaseCheck, c);
            }
            if (!inLine) {
                this.setBorder(BorderFactory.createTitledBorder(title));
            }
        }

        private JTextField createSearchField() {
            JTextField textField = new JTextField(10);
            textField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    SearchPanel.this.simpleSearch();
                }
            });
            return textField;
        }

        private JCheckBox createIgnoreCaseCheck() {
            if (this.ignoreCaseLabelText == null) {
                return null;
            }
            JCheckBox check = new JCheckBox(this.ignoreCaseLabelText);
            check.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchPanel.this.simpleSearch();
                }
            });
            return check;
        }

        private JButton createStepBackButton() {
            JButton stepBackButton = new JButton(GUIResources.BACK_ICON);
            stepBackButton.setPreferredSize(new Dimension(19, 19));
            stepBackButton.setToolTipText(this.previousToolTipText);
            stepBackButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchPanel.this.searchsWithNavigation(-1);
                }
            });
            return stepBackButton;
        }

        private JButton createStepForwardButton() {
            JButton stepForwardButton = new JButton(GUIResources.FORWARD_ICON);
            stepForwardButton.setPreferredSize(new Dimension(19, 19));
            stepForwardButton.setToolTipText(this.nextToolTipText);
            stepForwardButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchPanel.this.searchsWithNavigation(1);
                }
            });
            return stepForwardButton;
        }

        private void simpleSearch() {
            boolean hasText = false;
            int rowIndex = 0;
            SortableTable table = SortableTable.this;
            this.lastSearchedColIndexView = table.getSortedColIndexView();
            if (this.lastSearchedColIndexView == -1) {
                SortableTable.this.sort();
                this.lastSearchedColIndexView = table.getSortedColIndexView();
            }
            while (rowIndex < table.getRowCount()) {
                if (this.hasSearchTextInCurrentCellValue(table.getValueAt(rowIndex, this.lastSearchedColIndexView), this.searchField.getText(), this.ignoreCaseIsSelected())) {
                    hasText = true;
                    break;
                }
                ++rowIndex;
            }
            if (hasText) {
                this.selectMatchingRow(rowIndex);
            } else {
                this.clearMatchingRow();
            }
        }

        private void clearMatchingRow() {
            SortableTable.this.clearSelection();
            this.matchingRowIndex = -1;
        }

        private void searchsWithNavigation(int searchType) {
            int baseColIndex = SortableTable.this.getSortedColIndexView();
            if (this.lastSearchedColIndexView == -1 || this.lastSearchedColIndexView != SortableTable.this.getSortedColIndexView()) {
                this.matchingRowIndex = -1;
                this.lastSearchedColIndexView = baseColIndex < 0 ? 0 : baseColIndex;
            }
            int searchPointer = this.matchingRowIndex;
            searchPointer = this.nextRow(searchType, searchPointer);
            for (int i = 0; i < SortableTable.this.getRowCount(); ++i) {
                if (this.hasSearchTextInCurrentCellValue(SortableTable.this.getValueAt(searchPointer, this.lastSearchedColIndexView), this.searchField.getText(), this.ignoreCaseIsSelected())) {
                    this.selectMatchingRow(searchPointer);
                    break;
                }
                searchPointer = this.nextRow(searchType, searchPointer);
            }
        }

        private boolean ignoreCaseIsSelected() {
            if (this.ignoreCaseCheck == null) {
                return true;
            }
            return this.ignoreCaseCheck.isSelected();
        }

        private int nextRow(int searchType, int rowIndex) {
            int nextRow = rowIndex + searchType;
            if (searchType == 1 && nextRow >= SortableTable.this.getRowCount()) {
                nextRow = 0;
            } else if (searchType == -1 && nextRow < 0) {
                nextRow = SortableTable.this.getRowCount() - 1;
            }
            return nextRow;
        }

        private void selectMatchingRow(int rowIndex) {
            SortableTable.this.setRowSelectionInterval(rowIndex, rowIndex);
            Rectangle rect = SortableTable.this.getCellRect(rowIndex, 0, true);
            SortableTable.this.scrollRectToVisible(rect);
            this.matchingRowIndex = rowIndex;
        }

        private boolean hasSearchTextInCurrentCellValue(Object cellValue, String searchText, boolean ignoreCase) {
            if (cellValue != null && searchText != null && searchText.trim().length() > 0 && !this.hasSpecialChar(searchText)) {
                Pattern pattern = ignoreCase ? Pattern.compile(".*" + searchText + ".*", 2) : Pattern.compile(".*" + searchText + ".*");
                return pattern.matcher(cellValue.toString()).matches();
            }
            return false;
        }

        private boolean hasSpecialChar(String str) {
            String[] specialChar = new String[]{"'", "!", "@", "#", "$", "%", "\u00a8", "&", "*", "(", ")", "+", "=", "`", "'", "{", "[", "}", "]", "^", "~", "|", "\\", "<", ",", ">", ".", ":", ";", "?", "//", "*", "+"};
            if (str != null && str.trim().length() > 0) {
                for (int i = 0; i < specialChar.length; ++i) {
                    if (!str.contains(specialChar[i])) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
    }
}

