package tecgraf.javautils.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;

/**
 * Exemplo de uso da classe {@link GUIUtils}.
 *
 * @author Tecgraf/PUC-Rio
 */
public class GUIUtilsSample {

  /**
   * Teste manual para os mtodos visuais da classe. So construdos 2 painis,
   * o ao norte com o mtodo <code>addWithGridBagConstraints</code> e o do
   * centro com <code>createBasicGridPanel</code>. O painel do norte contm
   * ainda um boto que testa o <code>showErrorByButton</code>, enquanto que o
   * primeiro boto do painel do centro testa o <code>showErrorByField</code>.
   * 
   * @param args String[]
   */
  public static void main(String[] args) {
    final JFrame frame = new JFrame("Teste da classe GUIUtils");
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    // Painel do norte: teste do addWithGridBagConstraints
    JPanel northPanel = new JPanel();
    northPanel.setBorder(new BevelBorder(BevelBorder.RAISED));
    northPanel.setLayout(new GridBagLayout());
    JTextField f1 = new JTextField("TextField da esquerda");
    final JTextField f2 = new JTextField("TextField da direita");
    final JLabel l1 =
      new JLabel("<html>Este painel foi construdo com "
        + "<b>addWithGridBagConstraints</b></html>");
    JButton testShowErrorByButton = new JButton("showErrorByButton");
    testShowErrorByButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        GUIUtils.showErrorByButton(frame, "Teste do showErrorByButton", (JButton) e
          .getSource());
      }
    });

    JButton b2 = new JButton("Inativo");
    GridBagConstraints gc = new GridBagConstraints();
    GUIUtils.addWithGridBagConstraints(northPanel, l1, gc, 0, 0, 2, 1, 1, 1);
    GUIUtils.addWithGridBagConstraints(northPanel, f1, gc, 0, 1, 1, 2, 1, 1);
    GUIUtils.addWithGridBagConstraints(northPanel, f2, gc, 1, 1, 1, 2, 1, 1);
    GUIUtils.addWithGridBagConstraints(northPanel, testShowErrorByButton, gc,
      0, 3, 1, 1, 1, 1);
    GUIUtils.addWithGridBagConstraints(northPanel, b2, gc, 1, 3, 1, 1, 10, 1);
    northPanel.setBackground(Color.green);
    frame.getContentPane().add(northPanel, BorderLayout.NORTH);
    // Painel do centro: teste do createBasicGridPanel
    JLabel centerPanelTitle =
      new JLabel("<html>Este painel foi construdo com "
        + "<b>createBasicGridPanel</b></html>");
    centerPanelTitle.setForeground(Color.white);
    final JLabel label1 = new JLabel("campo 1:");
    final JTextField field1 = new JTextField("Erro na entrada");
    JButton testShowErrorByField = new JButton("showErrorByField");
    testShowErrorByField.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        GUIUtils.showErrorByTextField(frame, "Teste do showErrorByTextField", label1,
          field1);
      }
    });

    JComponent[][] components =
      new JComponent[][] {
          { null, centerPanelTitle, null },
          { label1, field1, testShowErrorByField },
          { new JLabel("campo 2:"), new JTextField(30), null },
          null,
          { null, new JTextField(30), new JButton("Inativo") },
          { new JLabel("campo 3:"), null, new JButton("Inativo") },
          { null, new JTextField(30), null },
          { new JLabel("Campo 4:"), null, null },
          { null, null, new JButton("Inativo") },
          { null, null, null },
          { new JLabel("campo 1:"), new JTextField(30), new JButton("Inativo"),
              new JLabel("No includo") } };
    JPanel centerPanel = GUIUtils.createBasicGridPanel(components);
    centerPanel.setBackground(Color.blue);
    centerPanel.setBorder(new BevelBorder(BevelBorder.RAISED));
    frame.getContentPane().add(centerPanel, BorderLayout.CENTER);
    frame.pack();
    frame.setVisible(true);
  }
}
