package tecgraf.javautils.gui.crud.demo;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.Locale;

import javax.swing.JFrame;
import javax.swing.JLabel;

import tecgraf.javautils.gui.crud.demo.descriptor.PlanesDescriptor;
import tecgraf.javautils.gui.crud.demo.logic.Plane;
import tecgraf.javautils.gui.crud.gui.main.RegistrationMainPanel;

/**
 * Demo.
 * 
 * @author Tecgraf
 */
public class PlanesDemo {

  /**
   * Main
   * 
   * @param args argumentos
   */
  public static void main(String args[]) {
    final JFrame frame = new JFrame();
    frame.setLayout(new BorderLayout());
    frame.add(BorderLayout.NORTH, new JLabel("Planes:"));

    final PlanesDescriptor descriptor = new PlanesDescriptor();
    final Locale locale = new Locale("en", "US");
    final RegistrationMainPanel<Plane, Plane> mainPanel =
      new RegistrationMainPanel<Plane, Plane>(descriptor, locale);
    frame.add(BorderLayout.CENTER, mainPanel);

    frame.setPreferredSize(new Dimension(800, 600));
    frame.setSize(new Dimension(800, 600));
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    frame.setVisible(true);
  }
}
