/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import tecgraf.javautils.gui.table.DefaultLineWrapTableCellRenderer;
import tecgraf.javautils.gui.table.SortableTable;
import tecgraf.javautils.gui.table.SortableTableListener;

public class SortableTableSample {
    public static void main(String[] args) {
        final TestModel model = new TestModel();
        final SortableTable table = new SortableTable(model);
        table.sort(new RowSorter.SortKey(1, SortOrder.ASCENDING), new RowSorter.SortKey(0, SortOrder.ASCENDING));
        table.setNoSortStateEnabled(true);
        table.setSelectionMode(0);
        table.setDefaultRenderer(Date.class, new MyDateTableCellRenderer());
        table.adjustColumnWidth();
        JScrollPane tablePane = new JScrollPane(table);
        final JLabel labelSelectedRow = new JLabel();
        JButton buttonSelectedRow = new JButton("Linha selecionada");
        buttonSelectedRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int viewRow = table.getSelectedRow();
                if (viewRow == -1) {
                    return;
                }
                int modelRow = table.convertRowIndexToModel(viewRow);
                labelSelectedRow.setText("View: " + viewRow + " / Model: " + modelRow);
            }
        });
        JButton buttonNewRow = new JButton("Nova linha");
        buttonNewRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                model.addRow("F", "Pablo\nPicasso", 23.0, new Date(5341242343L));
            }
        });
        JButton buttonRemoveRow = new JButton("Remove linha");
        buttonRemoveRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int viewRow = table.getSelectedRow();
                if (viewRow == -1) {
                    return;
                }
                int modelRow = table.convertRowIndexToModel(viewRow);
                model.removeRow(modelRow);
            }
        });
        JButton buttonAdjustColumns = new JButton("Ajusta colunas");
        buttonAdjustColumns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.adjustColumnWidth();
            }
        });
        String ACTIVATE_LINE_WRAP = "Ativa quebra de linha";
        String DEACTIVATE_LINE_WRAP = "Desativa quebra de linha";
        final JButton buttonLineWrap = new JButton("Ativa quebra de linha");
        buttonLineWrap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableColumn column = table.getColumnModel().getColumn(1);
                if (!(column.getCellRenderer() instanceof DefaultLineWrapTableCellRenderer)) {
                    DefaultLineWrapTableCellRenderer renderer = new DefaultLineWrapTableCellRenderer();
                    column.setCellRenderer(renderer);
                    buttonLineWrap.setText("Desativa quebra de linha");
                } else {
                    column.setCellRenderer(null);
                    buttonLineWrap.setText("Ativa quebra de linha");
                }
                table.adjustRowHeight();
            }
        });
        String DEACTIVATE_TOOLTIP = "Desativa tooltip";
        String ACTIVATE_TOOLTIP = "Ativa tooltip";
        final JButton buttonEnableToolTip = new JButton("Ativa tooltip");
        buttonEnableToolTip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (table.getToolTipEnabled()) {
                    table.setToolTipEnabled(false);
                    buttonEnableToolTip.setText("Ativa tooltip");
                } else {
                    table.setToolTipEnabled(true);
                    buttonEnableToolTip.setText("Desativa tooltip");
                }
                table.adjustRowHeight();
            }
        });
        JButton buttonSortColumn = new JButton("Coluna 3 Decrescente");
        buttonSortColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.sort(2, SortOrder.DESCENDING);
            }
        });
        String DEACTIVATE_COMPARATOR = "Comparador original";
        String ACTIVATE_COMPARATOR = "Comparador personalizado";
        final JButton buttonSetComparator = new JButton("Comparador personalizado");
        buttonSetComparator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (table.getComparator(1) instanceof TestComparator) {
                    table.setComparator(1, null);
                    buttonSetComparator.setText("Comparador personalizado");
                    table.sort(1, SortOrder.ASCENDING);
                } else {
                    table.setComparator(1, new TestComparator());
                    buttonSetComparator.setText("Comparador original");
                    table.sort(1, SortOrder.DESCENDING);
                }
            }
        });
        JButton buttonBaseColumn = new JButton("Coluna base");
        buttonBaseColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, table.getSortedColIndexView());
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.add(buttonSelectedRow);
        buttonPanel.add(buttonNewRow);
        buttonPanel.add(buttonRemoveRow);
        buttonPanel.add(buttonAdjustColumns);
        buttonPanel.add(buttonLineWrap);
        buttonPanel.add(buttonEnableToolTip);
        buttonPanel.add(buttonSortColumn);
        buttonPanel.add(buttonSetComparator);
        buttonPanel.add(buttonBaseColumn);
        final JLabel labelSortOrder = new JLabel();
        labelSortOrder.setForeground(Color.RED);
        table.addSortableTableListener(new SortableTableListener(){

            @Override
            public void tableSorted(Object source) {
                new Thread(){

                    @Override
                    public void run() {
                        labelSortOrder.setText("Tabela ordenada!");
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        labelSortOrder.setText("");
                    }
                }.start();
            }
        });
        JPanel searchPanel = table.createSearchPanel("Busca", "Ignorar acentos", "Anterior", "Pr\u00f3ximo", 0);
        JPanel statusBar = new JPanel(new FlowLayout(0));
        statusBar.add(searchPanel);
        statusBar.add(labelSortOrder);
        statusBar.add(labelSelectedRow);
        JFrame frame = new JFrame("1.6");
        frame.setDefaultCloseOperation(3);
        frame.add((Component)tablePane, "Center");
        frame.add((Component)buttonPanel, "West");
        frame.add((Component)statusBar, "South");
        int width = 650;
        int height = 400;
        frame.setSize(width, height);
        int FRAME_INTERNAL_MARGIN = 13;
        table.setPreferredScrollableViewportSize(new Dimension(width - 13, table.getPreferredScrollableViewportSize().height));
        frame.setVisible(true);
    }

    private static class MyDateTableCellRenderer
    extends DefaultTableCellRenderer {
        private MyDateTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Date) {
                DateFormat formatter = DateFormat.getDateTimeInstance(3, 3);
                ((DefaultTableCellRenderer)comp).setText(formatter.format(value));
            }
            return comp;
        }
    }

    private static class TestModel
    extends AbstractTableModel {
        List<List<?>> values = new ArrayList();
        String[] headers = new String[]{"Col A", "Col B", "Col C", "Col D"};

        public TestModel() {
            this.values.add(Arrays.asList("A", "Jo\u00e3o\nAna\nPaulo M\u00e1rio Achtung Filho", new Double(2.15), new Date(23412342343L)));
            this.values.add(Arrays.asList("D", "J\u00f3\nMac\nMari\nLuca", new Double(1.335), new Date(83412342343L)));
            this.values.add(Arrays.asList("g", "Rom\u00eao\nSelena", new Double(2.23), new Date(53412342343L)));
            this.values.add(Arrays.asList("v", "Luis\nLera\nRonald", new Double(11.0), new Date(13412342343L)));
            this.values.add(Arrays.asList("E", "", null, new Date(13412302343L)));
            this.values.add(Arrays.asList("S", null, new Double(665.5524), new Date(63412342343L)));
            this.values.add(Arrays.asList("Z", null, null, null));
        }

        public void addRow(String letter, String names, double number, Date date) {
            int newIndex = this.values.size();
            this.values.add(Arrays.asList(letter, names, number, date));
            this.fireTableRowsInserted(newIndex, newIndex);
        }

        public void removeRow(int modelRow) {
            this.values.remove(modelRow);
            this.fireTableRowsDeleted(modelRow, modelRow);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int colIndex) {
            return true;
        }

        @Override
        public int getRowCount() {
            return this.values.size();
        }

        @Override
        public int getColumnCount() {
            return this.values.get(0).size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.values.get(rowIndex).get(columnIndex);
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.headers[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.values.get(0).get(columnIndex).getClass();
        }
    }

    private static class TestComparator
    implements Comparator<String> {
        private TestComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1 == null || o1.length() == 0) {
                return -1;
            }
            if (o2 == null || o2.length() == 0) {
                return 1;
            }
            Character c1 = Character.valueOf(o1.charAt(o1.length() - 1));
            Character c2 = Character.valueOf(o2.charAt(o2.length() - 1));
            return c1.compareTo(c2);
        }
    }
}

