package tecgraf.javautils.gui.colorbutton;

import java.awt.BorderLayout;
import java.awt.Color;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * Exemplo de uso da classe {@link ColorButton}.
 *
 * @author Tecgraf/PUC-Rio
 */
public class ColorButtonSample {

  /**
   * Mtodo de teste para a classe. Cria uma janela com um boto para escolha da
   * cor do seu fundo.
   *
   * @param args
   */
  public static void main(String[] args) {
    final JFrame frame = new JFrame("Teste da ColorButton");
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    final JLabel label = new JLabel("Cor do fundo:");
    final Color clr = null; // Color.RED;
    ColorButton button = new ColorButton(clr);
    frame.getContentPane().setBackground(clr);

    button.addColorButtonChoiceListener(new ColorButtonChoiceListener() {
      @Override
      public void colorChosen(final ColorButton colorButton, final Color color) {
        System.out.println("Cor escolhida: " + color.toString());
        frame.getContentPane().setBackground(color);
      }
    });

    JPanel panel = new JPanel();
    panel.add(label);
    panel.add(button);
    frame.getContentPane().add(panel, BorderLayout.SOUTH);
    frame.setSize(250, 200);
    frame.setVisible(true);
  }
}
