package tecgraf.javautils.gui.field;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.Border;

/**
 * Classe genrica para campos com mscara e validao. A mscara  formada por
 * uma expresso regular definida pelo mtodo getMaskRegex. Possui opo de
 * trocar a cor de fundo caso o valor do campo no esteja vlido. Pode-se
 * adicionar um objeto de complemento de texto.  aconselhvel utilizar o mtodo
 * <code>init</code> no construtor da classe filha.
 */
public abstract class AbstractRegexField extends JTextField {

  /** expresso regular para representar qualquer texto */
  public static final String ANY_STRING_REGEX = ".*";

  /** cor do fundo para erro de validao */
  private Color backgroundError = Color.RED;

  /** cor do texto para erro de validacao */
  private Color foregroundError = Color.BLACK;

  /** flag para indicar se deve mostrar visualmente erro de validao */
  private boolean showValidation;

  /** borda original do componente */
  private Border originalBorder;

  /**
   * Construtor. Por default a cor de fundo no  trocada no caso de erro na
   * validao do valor do campo.
   */
  public AbstractRegexField() {
    this(false);
  }

  /**
   * Construtor.
   * 
   * @param showValidation Ativa a troca da cor do fundo caso o texto no esteja
   *        vlido.
   */
  public AbstractRegexField(boolean showValidation) {
    addKeyListener(new KeyListener() {
      public void keyTyped(KeyEvent e) {

      }

      public void keyPressed(KeyEvent e) {

      }

      public void keyReleased(KeyEvent e) {
        showValidation();
      }
    });
    this.showValidation = showValidation;
    originalBorder = getBorder();
  }

  @Override
  public void setText(String t) {
    super.setText(t);
    showValidation();
  }

  /**
   * Troca a cor do fundo de acordo com a validao.
   */
  private void showValidation() {
    if (showValidation) {
      if (isValidValue() || getText().length() == 0) {
        setBorder(originalBorder);
        setForeground(Color.BLACK);
      }
      else {
        setBorder(BorderFactory.createLineBorder(backgroundError, 2));
        setForeground(foregroundError);
      }
    }
  }

  /**
   * Verifica se o valor do campo  vlido.
   * 
   * @return boolean
   */
  public abstract boolean isValidValue();

  protected RegexDocument getRegexDocument() {
    if (getDocument() instanceof RegexDocument) {
      return (RegexDocument) getDocument();
    }
    return null;
  }

  /**
   * Altera a cor de fundo em caso de erro na auto-validao do campo
   * 
   * @param backgroundError
   */
  public void setBackgroundErrorColor(Color backgroundError) {
    this.backgroundError = backgroundError;
  }

  /**
   * Altera a cor de fundo em caso de erro na auto-validao do campo
   * 
   * @param backgroundError
   * @deprecated replaced by
   *             <code>setBackgroundErrorColor(backgroundError)</code>.
   */
  @Deprecated
  public void setBackgroundError(Color backgroundError) {
    this.backgroundError = backgroundError;
  }

  /**
   * Ativa a troca da cor do fundo caso o texto no esteja vlido.
   * 
   * @param showValidation
   */
  public void setBackgroundError(boolean showValidation) {
    this.showValidation = showValidation;
  }

  /**
   * Ativa a troca da cor do fundo caso o texto no esteja vlido.
   * 
   * @param showValidation
   * @deprecated replaced by <code>setBackgroundError(showValidation)</code>.
   */
  @Deprecated
  public void enableBackgroundError(boolean showValidation) {
    this.showValidation = showValidation;
  }

  /**
   * Seta a cor da letra em caso de erro na auto-validao do campo
   * 
   * @param foregroundError
   */
  public void setForegroundErrorColor(Color foregroundError) {
    this.foregroundError = foregroundError;
  }

  /**
   * Seta a cor da letra em caso de erro na auto-validao do campo
   * 
   * @param foregroundError
   * @deprecated replaced by
   *             <code>setForegroundErrorColor(foregroundError)</code>.
   */
  @Deprecated
  public void setForegroundError(Color foregroundError) {
    this.foregroundError = foregroundError;
  }
}
