/* 
 * $Author$
 * $Date$
 * $Revision: 65609 $
 */
package tecgraf.javautils.gui.tree;

import java.util.List;

import javax.swing.Icon;

/**
 * N de {@link Tree}.
 *
 * @author lmoreira
 */
public interface Node {
  /**
   * Modo de filtragem: indica ao filtro como proceder em relao a este n.
   */
  enum FiltrageMode {
    /**
     * Avalie: utilize o algoritmo padro ({@link Filter#isAccepted(Node)}) para
     * decidir se o n ser aceito ou rejeitado.
     */
    EVALUATE,
    
    /**
     * Ignore: no utiliza o filtro para decidir se o n ser aceito ou 
     *         rejeitado. Se pelo um dos seus ancestrais ou seus descendentes 
     *         for aceito, o n ir aparecer na rvore, caso contrrio, ele no 
     *         aparece na rvore.
     */
    IGNORE;
  }
  
  /**
   * <p>Obtm a lista de filhos deste n.</p>
   * 
   * <p>A lista retornada  imutvel 
   * (veja {@link java.util.Collections#unmodifiableList(List)}).</p>
   * 
   * @return A lista de filhos (Retorna uma lista vazia se no tiver filhos).
   */
  List<? extends Node> getChildren();

  /**
   * <p>Obtm o cone que dever representar este n.</p>
   * 
   * <p>Caso o n no precise definir um cone, este mtodo retornar 
   * {@code null} e o cone padro ser utilizado.</p>
   * 
   * @return O cone ou {@code null} para cone-padro.
   */
  Icon getIcon();
  
  /**
   * Obtm o rtulo deste n.
   * 
   * @return O rtulo (Pode ser {@code null}).
   */
  String getLabel();

  /**
   * Obtm o pai deste n.
   * 
   * @return O pai ou {@code null} se ele no tiver pai.
   */
  Node getParent();
  
  /**
   * Obtm o modo de filtragem deste n.
   * 
   * @return . 
   */
  FiltrageMode getFiltrageMode();
  
  /**
   * Altera o modo de filtragem deste n.
   * 
   * @param filtrageMode O modo de filtragem (No aceita {@code null}).
   */
  void setFiltrageMode(FiltrageMode filtrageMode);
}