package tecgraf.javautils.gui.wizard;

import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.imageio.ImageIO;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.WindowConstants;

import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.imagepanel.ImagePanel.HorAlign;
import tecgraf.javautils.gui.imagepanel.ImagePanel.VerAlign;
import tecgraf.javautils.gui.wizard.utils.changedlisteners.WasChangedActionListener;
import tecgraf.javautils.gui.wizard.utils.panels.LeftImagedPanel;

/**
 * Exemplo de uso da classe {@link Wizard}.
 *
 * @author Tecgraf/PUC-Rio
 */
public final class WizardSample extends JFrame implements IWizardListener {

  /**
   * Wizard
   */
  private Wizard wizard;

  /**
   * Construtor
   */
  private WizardSample() {
    super("Exemplo do Wizard");
    this.wizard = this.makeWizard();
    this.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
    this.getContentPane().add(wizard);
    this.pack();
  }

  /**
   * Criao interna de imagem com base em resource interno.
   *
   * @param imageIconName nome do resource
   * @return imagem
   */
  private static BufferedImage createImage(String imageIconName) {
    URL res = Wizard.class.getResource(imageIconName);
    if (res == null) {
      return null;
    }
    final BufferedImage buffImg;
    try {
      buffImg = ImageIO.read(res);
    }
    catch (IOException e) {
      return null;
    }
    return buffImg;
  }

  /**
   * Main
   *
   * @param args argumentos
   */
  public static void main(String[] args) {
    LNG.load("javautils_lng", new Locale("pt", "BR"));
    WizardSample frame = new WizardSample();
    frame.setVisible(true);
  }

  /**
   * Faz a montagem do wizard de exemplo.
   *
   * @return wizard
   */
  private Wizard makeWizard() {
    List<StepGroup> stepGroupList = new ArrayList<StepGroup>();
    StepGroup stepGroup1 = new StepGroup("Descrio");
    stepGroup1.add(new StepExample1());
    StepGroup stepGroup2 = new StepGroup("Descrio 2");
    stepGroup2.add(new StepExample2());
    stepGroupList.add(stepGroup1);
    stepGroupList.add(stepGroup2);
    Wizard wizard = new Wizard(StepExample1.class, stepGroupList, null, null,
      Wizard.FinishingType.CLOSEABLE, null, false);
    wizard.setHideFinishButtonsWhenDisabled(true);
    wizard.addListener(this);
    return wizard;
  }

  /**
   * Step 1
   *
   * @author Tecgraf/PUC-Rio
   */
  private static final class StepExample1 extends Step {
    /**
     * Painel
     */
    private LeftImagedPanel panel;

    /**
     * Widget de exemplo para habilitar o passo 2
     */
    private JCheckBox ckBox;

    /**
     * Construtor
     */
    StepExample1() {
      final BufferedImage stepImage = WizardSample.createImage(
        "WizardSample.png");

      ckBox = new JCheckBox("Clique aqui para habilitar o prximo passo!");
      ckBox.addActionListener(new WasChangedActionListener(this));
      ckBox.addActionListener(new ActionListener() {
        boolean toggle = false;

        @Override
        public void actionPerformed(ActionEvent e) {
          toggle = !toggle;
          StepExample1.this.panel.setLeftImage(toggle ? stepImage : null);
        }
      });

      panel = new LeftImagedPanel();
      panel.setLeftImage(stepImage);
      panel.setHorAlign(HorAlign.CENTER);
      panel.setVerAlign(VerAlign.CENTER);
      panel.setBackground(new Color(22, 107, 65));

      final JPanel chkPanel = new JPanel();
      chkPanel.add(ckBox);
      panel.setRightContainer(chkPanel);

      this.setConfirmOperation(ConfirmOperation.GO_NEXT);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean canCancel() {
      return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void cancel() throws WizardException {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean canConfirm() {
      return true;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected Object confirm(History history) throws WizardException {
      System.out.println("Confirmou...");
      return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void enter(History history) throws WizardException {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void exit(History history) {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected String getConfirmActionName() {
      return "Concluir";
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected String getConfirmActionTooltip() {
      return "Clique para concluir";
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected Container getContainer() {
      return panel;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected String getInstruction() {
      return "Instrues";
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected Class<? extends Step> getNext(History history) {
      return StepExample2.class;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected String getTitle() {
      return "Ttulo";
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean isTranslationCompleted(History history) {
      return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean isReady() {
      return ckBox.isSelected();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void translate(History history, Object data) {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean canClose() {
      return true;
    }
  }

  /**
   * Step 2
   *
   * @author Tecgraf/PUC-Rio
   */
  private static final class StepExample2 extends Step {

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean canCancel() {
      return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void cancel() throws WizardException {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean canConfirm() {
      return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected Object confirm(History history) throws WizardException {
      return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void enter(History history) throws WizardException {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void exit(History history) {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected String getConfirmActionName() {
      return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected String getConfirmActionTooltip() {
      return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected Container getContainer() {
      return new JPanel();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected String getInstruction() {
      return "Instrues 2";
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected Class<? extends Step> getNext(History history) {
      return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected String getTitle() {
      return "Ttulo 2";
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean isTranslationCompleted(History history) {
      return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean isReady() {
      return true;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void translate(History history, Object data) {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean canClose() {
      return false;
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasCancelled(Step step) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasClosed(Step step) {
    this.dispose();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasConfirmed(Step step, Object object) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasGoneNext(Step step, History history) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasGonePrevious(Step step, History history) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasHappenedException(Step step, WizardException exception) {
  }
}
