package tecgraf.javautils.gui.wizard.utils.panels;

import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Image;

import javax.swing.JLabel;
import javax.swing.JPanel;

import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.imagepanel.ImagePanel;
import tecgraf.javautils.gui.imagepanel.ImagePanel.HorAlign;
import tecgraf.javautils.gui.imagepanel.ImagePanel.VerAlign;

/**
 * Painel para a construo de painel composto de imagem  esquerda.
 *
 * @author Tecgraf/PUC-Rio
 */
public class LeftImagedPanel extends JPanel {

  /**
   * Cor default.
   */
  private static final Color DEFAULT_COLOR = new JLabel().getBackground();

  /**
   * Painel  esquerda para a imagem.
   */
  final private ImagePanel imagePanel;

  /**
   * Painel  direita para o contedo
   */
  private Container rightContainer;

  /**
   * Atualiza o container do lado direito.
   *
   * @param container container
   */
  private void updateContainer(Container container) {
    add(container, new GBC(1, 0).west().both(0.9, 1.0));
  }

  /**
   * Ajusta a imagem (lado esquerdo) do passo.
   *
   * @param image imagem
   * @return o objeto (this).
   */
  public final LeftImagedPanel setLeftImage(Image image) {
    imagePanel.setImage(image);
    return this;
  }

  /**
   * Ajusta o container do lado direito.
   *
   * @param container
   * @return o objeto (this)
   */
  public LeftImagedPanel setRightContainer(Container container) {
    this.rightContainer = container;
    super.remove(1);
    updateContainer(container);
    return this;
  }

  /**
   * Consulta o container do lado direito.
   *
   * @return container
   */
  public final Container getRightContainer() {
    return rightContainer;
  }

  /**
   * Consulta alinhamento.
   *
   * @return alinhamento.
   */
  public HorAlign getHorAlign() {
    return imagePanel.getHorAlign();
  }

  /**
   * Ajuste de alinhamento.
   *
   * @param horAlign alinhamento
   * @return o painel.
   */
  public LeftImagedPanel setHorAlign(HorAlign horAlign) {
    imagePanel.setHorAlign(horAlign);
    return this;
  }

  /**
   * Consulta alinhamento.
   *
   * @return alinhamento.
   */
  public VerAlign getVerAlign() {
    return imagePanel.getVerAlign();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setBackground(Color bg) {
    super.setBackground(bg);
    // Teste de nulidade pois o UIManager pode chamar este mtodo antes do
    // trmino da construo do objeto.
    if (imagePanel != null) {
      imagePanel.setBackground(bg);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Color getBackground() {
    // Teste de nulidade pois o UIManager pode chamar este mtodo antes do
    // trmino da construo do objeto.
    if (imagePanel == null) {
      return DEFAULT_COLOR;
    }
    return imagePanel.getBackground();
  }

  /**
   * Ajuste de alinhamento.
   *
   * @param verAlign alinhamento
   * @return o painel.
   */
  public LeftImagedPanel setVerAlign(VerAlign verAlign) {
    imagePanel.setVerAlign(verAlign);
    return this;
  }

  /**
   * Construtor
   */
  public LeftImagedPanel() {
    imagePanel = new ImagePanel();
    imagePanel.setHorAlign(HorAlign.CENTER);
    imagePanel.setVerAlign(VerAlign.CENTER);

    setLayout(new GridBagLayout());
    add(imagePanel, new GBC(0, 0).west().both(0.1, 1.0));
    updateContainer(new JLabel("- oo -"));
  }
}
