/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.wizard.utils.leftdecorations;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.plaf.ColorUIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import tecgraf.javautils.gui.wizard.History;
import tecgraf.javautils.gui.wizard.ILeftDecoration;
import tecgraf.javautils.gui.wizard.Step;
import tecgraf.javautils.gui.wizard.StepGroup;
import tecgraf.javautils.gui.wizard.WizardException;

public class FollowStepLeftDecoration
implements ILeftDecoration {
    private JScrollPane scrollPane;
    private JTextPane stepsTextPane;
    private List<StepGroup> stepGroupList;
    private String title = "";

    @Override
    public void wasClosed(Step step) {
    }

    @Override
    public void wasConfirmed(Step step, Object result) {
    }

    @Override
    public void wasGoneNext(Step step, History history) {
        this.showStepsDescription(step);
    }

    @Override
    public void wasGonePrevious(Step step, History history) {
        this.showStepsDescription(step);
    }

    @Override
    public void wasHappenedException(Step step, WizardException exception) {
    }

    private void showStepsDescription(Step step) {
        StepGroup stepGroup;
        Iterator<StepGroup> stepGroupIterator = this.stepGroupList.iterator();
        while (!(stepGroup = stepGroupIterator.next()).contains(step)) {
        }
        this.showStepsDescription(stepGroup);
    }

    private void createStylesOnTextPane() {
        Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        Style normalStyle = this.stepsTextPane.addStyle("normalStepStyle", defaultStyle);
        StyleConstants.setFontFamily(defaultStyle, "SansSerif");
        Style s = this.stepsTextPane.addStyle("currentStepStyle", normalStyle);
        StyleConstants.setItalic(s, true);
        StyleConstants.setForeground(s, new ColorUIResource(102, 102, 170));
        s = this.stepsTextPane.addStyle("titleStyle", normalStyle);
        StyleConstants.setFontSize(s, 16);
        s = this.stepsTextPane.addStyle("separator", defaultStyle);
        StyleConstants.setComponent(s, new JSeparator(0));
    }

    private void showStepsDescription(StepGroup currentGroup) {
        Document doc = this.stepsTextPane.getDocument();
        int caretPosition = 0;
        try {
            doc.remove(0, doc.getLength());
            doc.insertString(doc.getLength(), this.title + "\n", this.stepsTextPane.getStyle("titleStyle"));
            doc.insertString(doc.getLength(), "\n", this.stepsTextPane.getStyle("separator"));
            StringBuffer stepText = new StringBuffer();
            int stepIndex = 1;
            for (StepGroup stepGroup : this.stepGroupList) {
                stepText.setLength(0);
                stepText.append("\n");
                stepText.append(String.valueOf(stepIndex));
                stepText.append(". ");
                stepText.append(stepGroup.getDescription());
                stepText.append("\n");
                if (stepGroup.equals(currentGroup)) {
                    caretPosition = doc.getLength();
                    doc.insertString(doc.getLength(), stepText.toString(), this.stepsTextPane.getStyle("currentStepStyle"));
                } else {
                    doc.insertString(doc.getLength(), stepText.toString(), this.stepsTextPane.getStyle("normalStepStyle"));
                }
                ++stepIndex;
            }
            this.stepsTextPane.setCaretPosition(caretPosition);
        }
        catch (BadLocationException exception) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause(exception);
            throw ise;
        }
    }

    @Override
    public void wasCancelled(Step step) {
    }

    public FollowStepLeftDecoration(List<StepGroup> stepGroupList) {
        this.stepGroupList = stepGroupList;
        this.stepsTextPane = new JTextPane();
        this.stepsTextPane.setEditable(false);
        this.createStylesOnTextPane();
        int wid = 200;
        Dimension dim = new Dimension(200, 300);
        this.scrollPane.getViewport().add(this.stepsTextPane);
        this.scrollPane.setPreferredSize(dim);
        this.showStepsDescription(this.stepGroupList.get(0));
    }

    @Override
    public Component getComponent() {
        return this.scrollPane;
    }

    @Override
    public boolean isSplitPaneNeeded() {
        return true;
    }

    public final String getTitle() {
        return this.title;
    }

    public final FollowStepLeftDecoration setTitle(String title) {
        this.title = title == null ? "" : title;
        return this;
    }
}

