/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.jexpression;

import java.util.ArrayList;
import tecgraf.javautils.jexpression.JExpressionHandler;
import tecgraf.javautils.jexpression.exception.JExpressionException;
import tecgraf.javautils.jexpression.exception.JExpressionSyntaxErrorException;
import tecgraf.javautils.jexpression.parser.JParser;
import tecgraf.javautils.jexpression.parser.model.BinaryOp;
import tecgraf.javautils.jexpression.parser.model.DoubleValue;
import tecgraf.javautils.jexpression.parser.model.Exp;
import tecgraf.javautils.jexpression.parser.model.Field;
import tecgraf.javautils.jexpression.parser.model.FunctionCall;
import tecgraf.javautils.jexpression.parser.model.Group;
import tecgraf.javautils.jexpression.parser.model.Index;
import tecgraf.javautils.jexpression.parser.model.Question;
import tecgraf.javautils.jexpression.parser.model.UnaryOp;
import tecgraf.javautils.jexpression.parser.model.Var;

public class JExpression {
    private Exp exp;

    private JExpression(Exp exp) {
        if (exp == null) {
            throw new IllegalArgumentException("exp n\u00e3o pode ser nulo.");
        }
        this.exp = exp;
    }

    public static JExpression compile(String string) throws JExpressionSyntaxErrorException {
        if (string == null) {
            throw new IllegalArgumentException("input n\u00e3o pode ser nulo.");
        }
        Exp exp = new JParser().parse(string);
        return new JExpression(exp);
    }

    public Object eval(JExpressionHandler jExpressionHandler) throws Exception {
        return this.eval(jExpressionHandler, Object.class);
    }

    public <T> T eval(JExpressionHandler jExpressionHandler, Class<T> clazz) throws Exception {
        return (T)this.evaluate(this.exp, jExpressionHandler);
    }

    public String getCompiledExpression() {
        return this.exp.toString();
    }

    private Object evaluate(Exp exp, JExpressionHandler jExpressionHandler) throws Exception {
        if (exp instanceof DoubleValue) {
            return this.evalueate((DoubleValue)exp, jExpressionHandler);
        }
        if (exp instanceof BinaryOp) {
            return this.evaluate((BinaryOp)exp, jExpressionHandler);
        }
        if (exp instanceof UnaryOp) {
            return this.evaluate((UnaryOp)exp, jExpressionHandler);
        }
        if (exp instanceof Field) {
            return this.evaluate((Field)exp, jExpressionHandler);
        }
        if (exp instanceof Index) {
            return this.evaluate((Index)exp, jExpressionHandler);
        }
        if (exp instanceof FunctionCall) {
            return this.evaluate((FunctionCall)exp, jExpressionHandler);
        }
        if (exp instanceof Group) {
            return this.evaluate((Group)exp, jExpressionHandler);
        }
        if (exp instanceof Question) {
            return this.evaluate((Question)exp, jExpressionHandler);
        }
        if (exp instanceof Var) {
            return this.evaluate((Var)exp, jExpressionHandler);
        }
        String string = "Erro durante a avalia\u00e7\u00e3o da express\u00e3o '%s'";
        throw new JExpressionException(String.format(string, exp));
    }

    private Object evalueate(DoubleValue doubleValue, JExpressionHandler jExpressionHandler) throws Exception {
        return jExpressionHandler.handleDouble(doubleValue.getValue());
    }

    private Object evaluate(BinaryOp binaryOp, JExpressionHandler jExpressionHandler) throws Exception {
        Object object = this.evaluate(binaryOp.getFirst(), jExpressionHandler);
        Object object2 = this.evaluate(binaryOp.getSecond(), jExpressionHandler);
        switch (binaryOp.getOp()) {
            case PLUS: {
                return jExpressionHandler.handlePlus(object, object2);
            }
            case MINUS: {
                return jExpressionHandler.handleMinus(object, object2);
            }
            case TIMES: {
                return jExpressionHandler.handleTimes(object, object2);
            }
            case DIVIDE: {
                return jExpressionHandler.handleDivision(object, object2);
            }
            case POW: {
                return jExpressionHandler.handlePow(object, object2);
            }
            case GREATER: {
                return jExpressionHandler.handleGreater(object, object2);
            }
            case GREATER_EQ: {
                return jExpressionHandler.handleGreaterEqual(object, object2);
            }
            case LOWER: {
                return jExpressionHandler.handleLower(object, object2);
            }
            case LOWER_EQ: {
                return jExpressionHandler.handleLowerEqual(object, object2);
            }
            case EQUAL: {
                return jExpressionHandler.handleEqual(object, object2);
            }
            case NOT_EQUAL: {
                return jExpressionHandler.handleNotEqual(object, object2);
            }
            case AND: {
                return jExpressionHandler.handleAnd(object, object2);
            }
            case OR: {
                return jExpressionHandler.handleOr(object, object2);
            }
        }
        String string = "Erro durante a avalia\u00e7\u00e3o da express\u00e3o '%s'";
        throw new JExpressionException(String.format(string, binaryOp));
    }

    private Object evaluate(UnaryOp unaryOp, JExpressionHandler jExpressionHandler) throws Exception {
        Object object = this.evaluate(unaryOp.getExpression(), jExpressionHandler);
        switch (unaryOp.getOp()) {
            case NOT: {
                return jExpressionHandler.handleNot(object);
            }
            case MINUS: {
                return jExpressionHandler.handleUnaryMinus(object);
            }
        }
        String string = "Erro durante a avalia\u00e7\u00e3o da express\u00e3o '%s'";
        throw new JExpressionException(String.format(string, unaryOp));
    }

    private Object evaluate(FunctionCall functionCall, JExpressionHandler jExpressionHandler) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Exp exp : functionCall.getParams()) {
            arrayList.add(this.evaluate(exp, jExpressionHandler));
        }
        return jExpressionHandler.handleFunctionCall(functionCall.getName(), arrayList);
    }

    private Object evaluate(Question question, JExpressionHandler jExpressionHandler) throws Exception {
        Object object = this.evaluate(question.getCondition(), jExpressionHandler);
        Object object2 = this.evaluate(question.getThen(), jExpressionHandler);
        Object object3 = this.evaluate(question.getOtherwise(), jExpressionHandler);
        return jExpressionHandler.handleQuestion(object, object2, object3);
    }

    private Object evaluate(Var var, JExpressionHandler jExpressionHandler) throws Exception {
        return jExpressionHandler.handleVar(var.getName());
    }

    private Object evaluate(Field field, JExpressionHandler jExpressionHandler) throws Exception {
        Object object = this.evaluate(field.getExpression(), jExpressionHandler);
        return jExpressionHandler.handleField(object, field.getName());
    }

    private Object evaluate(Index index, JExpressionHandler jExpressionHandler) throws Exception {
        Object object = this.evaluate(index.getExpression(), jExpressionHandler);
        Object object2 = this.evaluate(index.getIndex(), jExpressionHandler);
        return jExpressionHandler.handleIndex(object, object2);
    }

    private Object evaluate(Group group, JExpressionHandler jExpressionHandler) throws Exception {
        return this.evaluate(group.getExpression(), jExpressionHandler);
    }
}

