/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.jexpression.util.function;

import tecgraf.javautils.jexpression.util.function.JExpressionSingleFunction;

public enum MathSingleFunctions {
    EXP{

        @Override
        public JExpressionSingleFunction<Double> getFunction() {
            return new JExpressionSingleFunction<Double>("exp"){

                public Double invoke(Double d) {
                    return Math.exp(d);
                }
            };
        }
    }
    ,
    LOG10{

        @Override
        public JExpressionSingleFunction<Double> getFunction() {
            return new JExpressionSingleFunction<Double>("log10"){

                public Double invoke(Double d) {
                    return Math.log10(d);
                }
            };
        }
    }
    ,
    LOG{

        @Override
        public JExpressionSingleFunction<Double> getFunction() {
            return new JExpressionSingleFunction<Double>("log"){

                public Double invoke(Double d) {
                    return Math.log(d);
                }
            };
        }
    }
    ,
    ROUND{

        @Override
        public JExpressionSingleFunction<Double> getFunction() {
            return new JExpressionSingleFunction<Double>("round"){

                public Double invoke(Double d) {
                    return Long.valueOf(Math.round(d)).doubleValue();
                }
            };
        }
    }
    ,
    FLOOR{

        @Override
        public JExpressionSingleFunction<Double> getFunction() {
            return new JExpressionSingleFunction<Double>("floor"){

                public Double invoke(Double d) {
                    return Math.floor(d);
                }
            };
        }
    }
    ,
    ABS{

        @Override
        public JExpressionSingleFunction<Double> getFunction() {
            return new JExpressionSingleFunction<Double>("abs"){

                public Double invoke(Double d) {
                    return Math.abs(d);
                }
            };
        }
    }
    ,
    CBRT{

        @Override
        public JExpressionSingleFunction<Double> getFunction() {
            return new JExpressionSingleFunction<Double>("cbrt"){

                public Double invoke(Double d) {
                    return Math.cbrt(d);
                }
            };
        }
    }
    ,
    SQRT{

        @Override
        public JExpressionSingleFunction<Double> getFunction() {
            return new JExpressionSingleFunction<Double>("sqrt"){

                public Double invoke(Double d) {
                    return Math.sqrt(d);
                }
            };
        }
    }
    ,
    TAN{

        @Override
        public JExpressionSingleFunction<Double> getFunction() {
            return new JExpressionSingleFunction<Double>("tan"){

                public Double invoke(Double d) {
                    return Math.tan(d);
                }
            };
        }
    }
    ,
    SIN{

        @Override
        public JExpressionSingleFunction<Double> getFunction() {
            return new JExpressionSingleFunction<Double>("sin"){

                public Double invoke(Double d) {
                    return Math.sin(d);
                }
            };
        }
    }
    ,
    COS{

        @Override
        public JExpressionSingleFunction<Double> getFunction() {
            return new JExpressionSingleFunction<Double>("cos"){

                public Double invoke(Double d) {
                    return Math.cos(d);
                }
            };
        }
    };


    public abstract JExpressionSingleFunction<Double> getFunction();
}

