package tecgraf.javautils.jexpression;

import java.util.List;

/**
 * Interface que define os tratadores das operaes da {@link JExpression}.
 * 
 * @author Tecgraf
 */
public interface JExpressionHandler {

  /**
   * Callback para valores {@link Double}.
   * 
   * @param value valor.
   * @return resultado.
   * 
   * @throws Exception em caso de erro.
   */
  public Object handleDouble(Double value) throws Exception;

  /**
   * Callback da operao '+'.
   * 
   * @param first primeiro operando.
   * @param second segundo operando.
   * @return resultado.
   * 
   * @throws Exception em caso de erro.
   */
  public Object handlePlus(Object first, Object second) throws Exception;

  /**
   * Callback de operao '-'.
   * 
   * @param first primeiro operando.
   * @param second segundo operando.
   * @return resultado.
   * 
   * @throws Exception em caso de erro.
   */
  public Object handleMinus(Object first, Object second) throws Exception;

  /**
   * Callback de operao '*'.
   * 
   * @param first primeiro operando.
   * @param second segundo operando.
   * @return resultado.
   * 
   * @throws Exception em caso de erro.
   */
  public Object handleTimes(Object first, Object second) throws Exception;

  /**
   * Callback de operao '/'.
   * 
   * @param first primeiro operando.
   * @param second segundo operando.
   * @return resultado.
   * 
   * @throws Exception em caso de erro.
   */
  public Object handleDivision(Object first, Object second) throws Exception;

  /**
   * Callback da operao '^'.
   * 
   * @param first primeiro operando.
   * @param second segundo operando.
   * @return resultado.
   * 
   * @throws Exception em caso de erro.
   */
  public Object handlePow(Object first, Object second) throws Exception;

  /**
   * Callback de operao '||'.
   * 
   * @param first primeiro operando.
   * @param second segundo operando.
   * @return resultado.
   * 
   * @throws Exception em caso de erro.
   */
  public Object handleOr(Object first, Object second) throws Exception;

  /**
   * Callback da operao '&&'.
   * 
   * @param first primeiro operando.
   * @param second segundo operando.
   * @return resultado.
   * 
   * @throws Exception em caso de erro.
   */
  public Object handleAnd(Object first, Object second) throws Exception;

  /**
   * Callback da operao '=='.
   * 
   * @param first primeiro operando.
   * @param second segundo operando.
   * @return resultado.
   * 
   * @throws Exception em caso de erro.
   */
  public Object handleEqual(Object first, Object second) throws Exception;

  /**
   * Callback da operao '!='.
   * 
   * @param first primeiro operando.
   * @param second segundo operando.
   * @return resultado.
   * 
   * @throws Exception em caso de erro.
   */
  public Object handleNotEqual(Object first, Object second) throws Exception;

  /**
   * Callback da operao '>'.
   * 
   * @param first primeiro operando.
   * @param second segundo operando.
   * @return resultado.
   * 
   * @throws Exception em caso de erro.
   */
  public Object handleGreater(Object first, Object second) throws Exception;

  /**
   * Callback da operao '>='.
   * 
   * @param first primeiro operando.
   * @param second segundo operando.
   * @return resultado.
   * 
   * @throws Exception em caso de erro.
   */
  public Object handleGreaterEqual(Object first, Object second)
    throws Exception;

/**
   * Callback da operao '<'.
   * 
   * @param first primeiro operando.
   * @param second segundo operando.
   * @return resultado.
   * 
   * @throws Exception em caso de erro.
   */
  public Object handleLower(Object first, Object second) throws Exception;

  /**
   * Callback da operao '<='.
   * 
   * @param first primeiro operando.
   * @param second segundo operando.
   * @return resultado.
   * 
   * @throws Exception em caso de erro.
   */
  public Object handleLowerEqual(Object first, Object second) throws Exception;

  /**
   * Callback do operador ternrio if-then-else (a ? b : c)
   * 
   * @param condition condio.
   * @param then ao.
   * @param otherwise caso contrrio.
   * @return resultado.
   * 
   * @throws Exception em caso de erro.
   */
  public Object handleQuestion(Object condition, Object then, Object otherwise)
    throws Exception;

  /**
   * Callback do operador unrio '-'.
   * 
   * @param object operando.
   * @return resultado.
   * 
   * @throws Exception em caso de erro.
   */
  public Object handleUnaryMinus(Object object) throws Exception;

  /**
   * Callback do operador unrio '!'.
   * 
   * @param object operando.
   * @return resultado.
   * 
   * @throws Exception em caso de erro.
   */
  public Object handleNot(Object object) throws Exception;

  /**
   * Callback de varivel.
   * 
   * @param name nome da varivel.
   * @return resultado.
   * 
   * @throws Exception em caso de erro.
   */
  public Object handleVar(String name) throws Exception;

  /**
   * Callback de indexao.
   * 
   * @param object objeto a ser indexado.
   * @param index ndice.
   * @return resultado da indexao.
   * 
   * @throws Exception em caso de erro.
   */
  public Object handleIndex(Object object, Object index) throws Exception;

  /**
   * Callback de acesso a um campo de objeto.
   * 
   * @param object primeiro operando.
   * @param field campo.
   * @return resultado.
   * 
   * @throws Exception em caso de erro.
   */
  public Object handleField(Object object, String field) throws Exception;

  /**
   * Callback de chamada de funo.
   * 
   * @param functionName nome funo.
   * @param params lista de parmetros.
   * @return resultado da chamada de funo.
   * 
   * @throws Exception em caso de erro.
   */
  public Object handleFunctionCall(String functionName, List<Object> params)
    throws Exception;
}
