package tecgraf.javautils.jexpression.parser.model;

/**
 * Classe que armazena um acesso a campo.
 * 
 * Ex: point.x, point.y, panel.graphics.width, (a + b).c, list[i].height
 * 
 * @author Tecgraf
 */
public class Field extends Exp {

  /** Expresso. */
  private Exp expression;

  /** Nome. */
  private String name;

  /**
   * Construtor.
   * 
   * @param expression expresso.
   * @param name nome.
   */
  public Field(Exp expression, String name) {
    if (expression == null) {
      throw new IllegalArgumentException("expression no pode ser nulo.");
    }
    if (name == null) {
      throw new IllegalArgumentException("name no pode ser nulo.");
    }
    this.expression = expression;
    this.name = name;
  }

  /**
   * Expresso.
   * 
   * @return expresso.
   */
  public Exp getExpression() {
    return expression;
  }

  /**
   * Nome.
   * 
   * @return nome.
   */
  public String getName() {
    return name;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return String.format("%s.%s", expression, name);
  }
}
