/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.jexpression.scanner;

import java.util.regex.Matcher;
import tecgraf.javautils.jexpression.scanner.Symbol;
import tecgraf.javautils.jexpression.scanner.Token;

public class JScanner {
    private String input;
    private int lineNumber;
    private int index;

    public JScanner(String input) {
        if (input == null) {
            throw new IllegalArgumentException("input n\u00e3o pode ser nulo.");
        }
        this.input = input;
        this.lineNumber = 1;
        this.index = 0;
    }

    public Token nextToken() {
        this.normalize();
        if (this.over()) {
            return null;
        }
        for (Symbol type : Symbol.values()) {
            Matcher m = type.pattern.matcher(this.input);
            m.region(this.index, this.input.length());
            if (!m.find()) continue;
            this.index = m.end();
            return new Token(type, this.lineNumber, m.group());
        }
        return null;
    }

    private void normalize() {
        if (this.over()) {
            return;
        }
        char c = this.input.charAt(this.index);
        if (c == ' ' || c == '\n' || c == '\t') {
            ++this.index;
            if (c == '\n') {
                ++this.lineNumber;
            }
            this.normalize();
        }
    }

    public boolean over() {
        return this.input.length() == 0 || this.index == this.input.length();
    }
}

