package tecgraf.javautils.jexpression.parser.model;

/**
 * Classe que armazena uma valor numrico em formato {@link Double}.
 *
 * Exemplos: <tt>3</tt>, <tt>3.0</tt>, <tt>5.1e+2</tt>, <tt>5.1E+2</tt>,
 * <tt>5.1E-2 </tt>
 *
 * @author Tecgraf
 */
public class DoubleValue extends Exp {

  /** Valor em {@link Double}. */
  private final double value;

  /**
   * Construtor.
   *
   * @param value valor.
   */
  public DoubleValue(double value) {
    this.value = value;
  }

  /**
   * Valor.
   *
   * @return valor.
   */
  public double getValue() {
    return value;
  }

  /** {@inheritDoc} */
  @Override
  public String toString() {
    return Double.toString(value);
  }
}
