package tecgraf.javautils.jexpression.parser.model;

/**
 * Classe que armazena uma valor string em formato {@link String}.
 *
 * Exemplos: <tt>"abc"3</tt>, <tt>"minha casa"3.0</tt>
 *
 * @author Tecgraf
 */
public class StringValue extends Exp {

  /** Valor em {@link String}. */
  private final String value;

  /**
   * Construtor.
   *
   * @param value valor.
   */
  public StringValue(String value) {
    this.value = value;
  }

  /**
   * Valor.
   *
   * @return valor.
   */
  public String getValue() {
    return value.replaceAll("\"", "");
  }

  /** {@inheritDoc} */
  @Override
  public String toString() {
    return "'" + value + "'";
  }
}
