package tecgraf.javautils.jexpression.samples;

import java.nio.charset.Charset;
import java.util.Scanner;

import tecgraf.javautils.jexpression.JExpression;
import tecgraf.javautils.jexpression.util.CalculatorHandler;

/**
 * Utilitrio que calcula a dada expresso.
 *
 * @author Tecgraf
 */
public class Calculator {

  /**
   * Programa.
   *
   * @param args argumentos.
   */
  public static void main(String[] args) {
    final Charset charset = Charset.defaultCharset();
    Scanner scanner = new Scanner(System.in, charset.name());

    CalculatorHandler handler = new CalculatorHandler();
    handler.registerBasicFunctions();

    while (true) {
      System.out.println("Digite expresso (opes: 'help' e 'exit'):");
      String line = scanner.nextLine();
      if (line.trim().isEmpty()) {
        System.out.println("");
        continue;
      }
      if (line.contains("help")) {
        System.out.println("Para definir variveis: define <nome> <valor>");
        continue;
      }
      if (line.contains("define")) {
        String[] values = line.split(" +");
        if (values.length != 3) {
          System.out.println("Operao 'define' requer 2 argumentos.");
          continue;
        }
        Object value = getValue(values[2]);
        if (value != null) {
          handler.addVariable(values[1], value);
        }
        continue;
      }
      if (line.contains("exit")) {
        break;
      }
      evaluate(line, handler);
    }
    scanner.close();
  }

  /**
   * Retorna um valor {@link Boolean} ou {@link Double} de acordo com a dada
   * {@link String}.
   *
   * @param value valor {@link String}.
   * @return valor.
   */
  private static Object getValue(String value) {
    if (value.equals("true")) {
      return Boolean.TRUE;
    }
    if (value.equals("false")) {
      return Boolean.FALSE;
    }
    try {
      return Double.valueOf(value);
    }
    catch (NumberFormatException nfe) {
      System.out.println("Aviso: operao 'define' fez atribuio como string.");
      return value;
    }
  }

  /**
   * Avalia a expresso.
   *
   * @param entry entrada.
   * @param handler tratador de expresses.
   */
  private static void evaluate(String entry, CalculatorHandler handler) {
    try {
      JExpression expression = JExpression.compile(entry);
      Object result = expression.eval(handler);
      if (result instanceof String) {
        System.out.println("String: \"" + result + "\"");
      }
      else if (result instanceof Boolean) {
        boolean r = (Boolean) result;
        System.out.println("Boolean: " + (r ? Boolean.TRUE : Boolean.FALSE));
      }
      else if (result instanceof Double) {
        System.out.println("Number: " + result);
      }
      else {
        System.out.println("Object: " + result);
      }
    }
    catch (Exception e) {
      System.out.println(e.getMessage());
    }
  }
}
