package tecgraf.javautils.jexpression.samples;

import java.nio.charset.Charset;
import java.util.Scanner;

import tecgraf.javautils.jexpression.JExpression;
import tecgraf.javautils.jexpression.util.PrintHandler;

/**
 * Utilitrio que imprime a ordem de avaliao da dada expresso.
 *
 * @author Tecgraf
 */
public class Print {

  /**
   * Programa.
   *
   * @param args argumentos.
   */
  public static void main(String[] args) {
    System.out.println("Digite expresso:");
    final Charset charset = Charset.defaultCharset();
    Scanner scanner = new Scanner(System.in, charset.name());
    String input = scanner.nextLine();

    try {
      JExpression expression = JExpression.compile(input);
      expression.eval(new PrintHandler());
    }
    catch (Exception e) {
      System.out.println(e.getMessage());
      e.printStackTrace();
    }
    finally {
      scanner.close();
    }
  }
}
