package tecgraf.javautils.jexpression.samples;

import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Scanner;

import tecgraf.javautils.jexpression.JExpression;
import tecgraf.javautils.jexpression.util.VarNamesHandler;

/**
 * Utilitrio que imprime a ordem de avaliao da dada expresso.
 *
 * @author Tecgraf
 */
public class VarNames {

  /**
   * Programa.
   *
   * @param args argumentos.
   */
  public static void main(String[] args) {
    System.out.println("Digite expresso:");
    final Charset charset = Charset.defaultCharset();
    Scanner scanner = new Scanner(System.in, charset.name());
    String input = scanner.nextLine();

    try {
      JExpression expression = JExpression.compile(input);
      Object result = expression.eval(new VarNamesHandler());
      if (result instanceof HashSet) {
        HashSet<String> names = (HashSet<String>) result;
        for (String name : names) {
          System.out.println("* " + name);
        }
      }
    }
    catch (Exception e) {
      System.out.println(e.getMessage());
    }
    finally {
      scanner.close();
    }
  }
}
