package tecgraf.javautils.jexpression.util.function;

/**
 * Funes aritmticas bsicas.
 * 
 * @author Tecgraf/PUC-Rio
 */
public enum BasicFunctions {

  /** exp. */
  EXP(createExpFunction()),

  /** log10. */
  LOG10(createLog10Function()),

  /** log. */
  LOG(createLogFunction()),

  /** round. */
  ROUND(createRoundFunction()),

  /** floor. */
  FLOOR(createFloorFunction()),

  /** abs. */
  ABS(createAbsFunction()),

  /** cbrt. */
  CBRT(createCbrtFunction()),

  /** sqrt. */
  SQRT(createSqrtFunction()),

  /** tan. */
  TAN(createTanFunction()),

  /** sin. */
  SIN(createSinFunction()),

  /** cos. */
  COS(createCosFunction()),

  /** max. */
  MAX(createMaxFunction()),

  /** min. */
  MIN(createMinFunction()),

  /** tonumber. */
  TONUMBER(createToNumberFunction()),

  /** toboolean. */
  TOBOOLEAN(createToBooleanFunction()),

  /** tostring. */
  TOSTRING(createToStringFunction()),

  /** length. */
  STRLEN(createStrlenFunction());

  /** Funo relacionada a constante. */
  public final JExpressionFunction function;

  /**
   * Construtor.
   * 
   * @param function funo.
   */
  private BasicFunctions(JExpressionFunction function) {
    this.function = function;
  }

  /**
   * Funo 'exp'.
   * 
   * @return funo.
   */
  private static JExpressionFunction createExpFunction() {
    return new JExpressionFunction("exp") {
      @Override
      public Object call(Object... params) {
        if (params.length != 1) {
          String f = "Funo '%s' deve receber 1 parmetro.";
          throw new IllegalArgumentException(String.format(f, getName()));
        }
        return Math.exp((Double) params[0]);
      }
    };
  }

  /**
   * Funo 'log10'.
   * 
   * @return funo.
   */
  private static JExpressionFunction createLog10Function() {
    return new JExpressionFunction("log10") {
      @Override
      public Object call(Object... params) {
        if (params.length != 1) {
          String f = "Funo '%s' deve receber 1 parmetro.";
          throw new IllegalArgumentException(String.format(f, getName()));
        }
        return Math.log10((Double) params[0]);
      }
    };
  }

  /**
   * Funo 'log'.
   * 
   * @return funo.
   */
  private static JExpressionFunction createLogFunction() {
    return new JExpressionFunction("log") {
      @Override
      public Object call(Object... params) {
        if (params.length != 1) {
          String f = "Funo '%s' deve receber 1 parmetro.";
          throw new IllegalArgumentException(String.format(f, getName()));
        }
        return Math.log((Double) params[0]);
      }
    };
  }

  /**
   * Funo 'round'.
   * 
   * @return funo.
   */
  private static JExpressionFunction createRoundFunction() {
    return new JExpressionFunction("round") {
      @Override
      public Object call(Object... params) {
        if (params.length != 1) {
          String f = "Funo '%s' deve receber 1 parmetro.";
          throw new IllegalArgumentException(String.format(f, getName()));
        }
        Long result = Math.round((Double) params[0]);
        return result.doubleValue();
      }
    };
  }

  /**
   * Funo 'floor'.
   * 
   * @return funo.
   */
  private static JExpressionFunction createFloorFunction() {
    return new JExpressionFunction("floor") {
      @Override
      public Object call(Object... params) {
        if (params.length != 1) {
          String f = "Funo '%s' deve receber 1 parmetro.";
          throw new IllegalArgumentException(String.format(f, getName()));
        }
        return Math.floor((Double) params[0]);
      }
    };
  }

  /**
   * Funo 'abs'.
   * 
   * @return funo.
   */
  private static JExpressionFunction createAbsFunction() {
    return new JExpressionFunction("abs") {
      @Override
      public Object call(Object... params) {
        if (params.length != 1) {
          String f = "Funo '%s' deve receber 1 parmetro.";
          throw new IllegalArgumentException(String.format(f, getName()));
        }
        return Math.abs((Double) params[0]);
      }
    };
  }

  /**
   * Funo 'cbrt'.
   * 
   * @return funo.
   */
  private static JExpressionFunction createCbrtFunction() {
    return new JExpressionFunction("cbrt") {
      @Override
      public Object call(Object... params) {
        if (params.length != 1) {
          String f = "Funo '%s' deve receber 1 parmetro.";
          throw new IllegalArgumentException(String.format(f, getName()));
        }
        return Math.cbrt((Double) params[0]);
      }
    };
  }

  /**
   * Funo 'sqrt'.
   * 
   * @return funo.
   */
  private static JExpressionFunction createSqrtFunction() {
    return new JExpressionFunction("sqrt") {
      @Override
      public Object call(Object... params) {
        if (params.length != 1) {
          String f = "Funo '%s' deve receber 1 parmetro.";
          throw new IllegalArgumentException(String.format(f, getName()));
        }
        return Math.sqrt((Double) params[0]);
      }
    };
  }

  /**
   * Funo 'tan'.
   * 
   * @return funo.
   */
  private static JExpressionFunction createTanFunction() {
    return new JExpressionFunction("tan") {
      @Override
      public Object call(Object... params) {
        if (params.length != 1) {
          String f = "Funo '%s' deve receber 1 parmetro.";
          throw new IllegalArgumentException(String.format(f, getName()));
        }
        return Math.tan((Double) params[0]);
      }
    };
  }

  /**
   * Funo 'sin'.
   * 
   * @return funo.
   */
  private static JExpressionFunction createSinFunction() {
    return new JExpressionFunction("sin") {
      @Override
      public Object call(Object... params) {
        if (params.length != 1) {
          String f = "Funo '%s' deve receber 1 parmetro.";
          throw new IllegalArgumentException(String.format(f, getName()));
        }
        return Math.sin((Double) params[0]);
      }
    };
  }

  /**
   * Funo 'cos'.
   * 
   * @return funo.
   */
  private static JExpressionFunction createCosFunction() {
    return new JExpressionFunction("cos") {
      @Override
      public Object call(Object... params) {
        if (params.length != 1) {
          String f = "Funo '%s' deve receber 1 parmetro.";
          throw new IllegalArgumentException(String.format(f, getName()));
        }
        return Math.cos((Double) params[0]);
      }
    };
  }

  /**
   * Funo 'max'.
   * 
   * @return funo.
   */
  private static JExpressionFunction createMaxFunction() {
    return new JExpressionFunction("max") {
      @Override
      public Object call(Object... params) {
        if (params.length < 1) {
          String f = "Funo '%s' deve receber pelo menos 1 parmetro.";
          throw new IllegalArgumentException(String.format(f, getName()));
        }
        Double max = (Double) params[0];
        for (Object param : params) {
          max = Math.max(max, (Double) param);
        }
        return max;
      }
    };
  }

  /**
   * Funo 'min'.
   * 
   * @return funo.
   */
  private static JExpressionFunction createMinFunction() {
    return new JExpressionFunction("min") {
      @Override
      public Object call(Object... params) {
        if (params.length < 1) {
          String f = "Funo '%s' deve receber pelo menos 1 parmetro.";
          throw new IllegalArgumentException(String.format(f, getName()));
        }
        Double min = (Double) params[0];
        for (Object param : params) {
          min = Math.min(min, (Double) param);
        }
        return min;
      }
    };
  }

  /**
   * Funo 'strlen'.
   * 
   * @return funo.
   */
  private static JExpressionFunction createStrlenFunction() {
    return new JExpressionFunction("strlen") {
      @Override
      public Object call(Object... params) {
        if (params.length != 1) {
          String f = "Funo '%s' deve receber um nico parmetro.";
          throw new IllegalArgumentException(String.format(f, getName()));
        }
        Object param = params[0];
        if (param instanceof String) {
          return (double) ((String) param).length();
        }
        String f = "Funo '%s' deve receber um parmetro string.";
        throw new IllegalArgumentException(String.format(f, getName()));
      }
    };
  }

  /**
   * Funo 'toboolean'.
   * 
   * @return funo.
   */
  private static JExpressionFunction createToBooleanFunction() {
    return new JExpressionFunction("toboolean") {
      @Override
      public Object call(Object... params) {
        if (params.length != 1) {
          String f = "Funo '%s' deve receber um nico parmetro.";
          throw new IllegalArgumentException(String.format(f, getName()));
        }
        Object param = params[0];
        if (param instanceof String) {
          String str = ((String) param).trim();
          if (str.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
          }
          if (str.equalsIgnoreCase("false")) {
            return Boolean.TRUE;
          }
          String f = "Funo '%s' falhou na converso de '%s' para booleano ('true' or 'false').";
          throw new IllegalArgumentException(String.format(f, getName(), param));
        }
        String f = "Funo '%s' deve receber um parmetro string.";
        throw new IllegalArgumentException(String.format(f, getName()));
      }
    };
  }

  /**
   * Funo 'tonumber'.
   * 
   * @return funo.
   */
  private static JExpressionFunction createToNumberFunction() {
    return new JExpressionFunction("tonumber") {
      @Override
      public Object call(Object... params) {
        if (params.length != 1) {
          String f = "Funo '%s' deve receber um nico parmetro.";
          throw new IllegalArgumentException(String.format(f, getName()));
        }
        Object param = params[0];
        if (param instanceof String) {
          try {
            return Double.parseDouble((String) param);
          }
          catch (NumberFormatException nfe) {
            String f = "Funo '%s' falhou na converso de '%s' para nmero.";
            throw new IllegalArgumentException(String.format(f, getName(), param));
          }
        }
        String f = "Funo '%s' deve receber um parmetro string.";
        throw new IllegalArgumentException(String.format(f, getName()));
      }
    };
  }

  /**
   * Funo 'tostring'.
   * 
   * @return funo.
   */
  private static JExpressionFunction createToStringFunction() {
    return new JExpressionFunction("tostring") {
      @Override
      public Object call(Object... params) {
        if (params.length != 1) {
          String f = "Funo '%s' deve receber um nico parmetro.";
          throw new IllegalArgumentException(String.format(f, getName()));
        }
        Object param = params[0];
        return param.toString();
      }
    };
  }

}
