/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.jexpression;

import java.util.ArrayList;
import tecgraf.javautils.jexpression.JExpressionHandler;
import tecgraf.javautils.jexpression.exception.JExpressionException;
import tecgraf.javautils.jexpression.exception.JExpressionSyntaxErrorException;
import tecgraf.javautils.jexpression.parser.JParser;
import tecgraf.javautils.jexpression.parser.model.BinaryOp;
import tecgraf.javautils.jexpression.parser.model.DoubleValue;
import tecgraf.javautils.jexpression.parser.model.Exp;
import tecgraf.javautils.jexpression.parser.model.Field;
import tecgraf.javautils.jexpression.parser.model.FunctionCall;
import tecgraf.javautils.jexpression.parser.model.Group;
import tecgraf.javautils.jexpression.parser.model.Index;
import tecgraf.javautils.jexpression.parser.model.Question;
import tecgraf.javautils.jexpression.parser.model.StringValue;
import tecgraf.javautils.jexpression.parser.model.UnaryOp;
import tecgraf.javautils.jexpression.parser.model.Var;

public class JExpression {
    private Exp exp;

    private JExpression(Exp exp) {
        if (exp == null) {
            throw new IllegalArgumentException("exp n\u00e3o pode ser nulo.");
        }
        this.exp = exp;
    }

    public static JExpression compile(String input) throws JExpressionSyntaxErrorException {
        if (input == null) {
            throw new IllegalArgumentException("input n\u00e3o pode ser nulo.");
        }
        Exp expression = new JParser().parse(input);
        return new JExpression(expression);
    }

    public Object eval(JExpressionHandler handler) throws Exception {
        return this.eval(handler, Object.class);
    }

    public <T> T eval(JExpressionHandler handler, Class<T> c) throws Exception {
        return (T)this.evaluate(this.exp, handler);
    }

    public String getCompiledExpression() {
        return this.exp.toString();
    }

    private Object evaluate(Exp expression, JExpressionHandler handler) throws Exception {
        if (expression instanceof DoubleValue) {
            return this.evaluate((DoubleValue)expression, handler);
        }
        if (expression instanceof StringValue) {
            return this.evaluate((StringValue)expression, handler);
        }
        if (expression instanceof BinaryOp) {
            return this.evaluate((BinaryOp)expression, handler);
        }
        if (expression instanceof UnaryOp) {
            return this.evaluate((UnaryOp)expression, handler);
        }
        if (expression instanceof Field) {
            return this.evaluate((Field)expression, handler);
        }
        if (expression instanceof Index) {
            return this.evaluate((Index)expression, handler);
        }
        if (expression instanceof FunctionCall) {
            return this.evaluate((FunctionCall)expression, handler);
        }
        if (expression instanceof Group) {
            return this.evaluate((Group)expression, handler);
        }
        if (expression instanceof Question) {
            return this.evaluate((Question)expression, handler);
        }
        if (expression instanceof Var) {
            return this.evaluate((Var)expression, handler);
        }
        String f = "Erro durante a avalia\u00e7\u00e3o da express\u00e3o '%s'";
        throw new JExpressionException(String.format(f, expression));
    }

    private Object evaluate(DoubleValue valor, JExpressionHandler handler) throws Exception {
        return handler.handleDouble(valor.getValue());
    }

    private Object evaluate(StringValue valor, JExpressionHandler handler) throws Exception {
        return handler.handleString(valor.getValue());
    }

    private Object evaluate(BinaryOp binaryOp, JExpressionHandler handler) throws Exception {
        Object first = this.evaluate(binaryOp.getFirst(), handler);
        Object second = this.evaluate(binaryOp.getSecond(), handler);
        switch (binaryOp.getOp()) {
            case PLUS: {
                return handler.handlePlus(first, second);
            }
            case MINUS: {
                return handler.handleMinus(first, second);
            }
            case TIMES: {
                return handler.handleTimes(first, second);
            }
            case DIVIDE: {
                return handler.handleDivision(first, second);
            }
            case POW: {
                return handler.handlePow(first, second);
            }
            case GREATER: {
                return handler.handleGreater(first, second);
            }
            case GREATER_EQ: {
                return handler.handleGreaterEqual(first, second);
            }
            case LOWER: {
                return handler.handleLower(first, second);
            }
            case LOWER_EQ: {
                return handler.handleLowerEqual(first, second);
            }
            case EQUAL: {
                return handler.handleEqual(first, second);
            }
            case NOT_EQUAL: {
                return handler.handleNotEqual(first, second);
            }
            case AND: {
                return handler.handleAnd(first, second);
            }
            case OR: {
                return handler.handleOr(first, second);
            }
        }
        String f = "Erro durante a avalia\u00e7\u00e3o da express\u00e3o '%s'";
        throw new JExpressionException(String.format(f, binaryOp));
    }

    private Object evaluate(UnaryOp unaryOp, JExpressionHandler handler) throws Exception {
        Object result = this.evaluate(unaryOp.getExpression(), handler);
        switch (unaryOp.getOp()) {
            case NOT: {
                return handler.handleNot(result);
            }
            case MINUS: {
                return handler.handleUnaryMinus(result);
            }
        }
        String f = "Erro durante a avalia\u00e7\u00e3o da express\u00e3o '%s'";
        throw new JExpressionException(String.format(f, unaryOp));
    }

    private Object evaluate(FunctionCall functioncall, JExpressionHandler handler) throws Exception {
        ArrayList<Object> params = new ArrayList<Object>();
        for (Exp param : functioncall.getParams()) {
            params.add(this.evaluate(param, handler));
        }
        return handler.handleFunctionCall(functioncall.getName(), params);
    }

    private Object evaluate(Question question, JExpressionHandler handler) throws Exception {
        Object condition = this.evaluate(question.getCondition(), handler);
        Object then = this.evaluate(question.getThen(), handler);
        Object otherwise = this.evaluate(question.getOtherwise(), handler);
        return handler.handleQuestion(condition, then, otherwise);
    }

    private Object evaluate(Var var, JExpressionHandler handler) throws Exception {
        return handler.handleVar(var.getName());
    }

    private Object evaluate(Field field, JExpressionHandler handler) throws Exception {
        Object result = this.evaluate(field.getExpression(), handler);
        return handler.handleField(result, field.getName());
    }

    private Object evaluate(Index index, JExpressionHandler handler) throws Exception {
        Object result = this.evaluate(index.getExpression(), handler);
        Object i = this.evaluate(index.getIndex(), handler);
        return handler.handleIndex(result, i);
    }

    private Object evaluate(Group group, JExpressionHandler handler) throws Exception {
        return this.evaluate(group.getExpression(), handler);
    }
}

