/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.launcher;

import java.nio.file.Path;

public enum OS {
    WINDOWS("", true),
    LINUX(".", false),
    MAC(".", false),
    SOLARIS(".", false);

    private String pathPrefix;
    public final boolean allowsShortcut;

    private OS(String pathPrefix, boolean allowsShortcut) {
        this.pathPrefix = pathPrefix;
        this.allowsShortcut = allowsShortcut;
    }

    public static OS getOS() {
        String operSys = System.getProperty("os.name").toLowerCase();
        if (operSys.contains("win")) {
            return WINDOWS;
        }
        if (operSys.contains("nix") || operSys.contains("nux") || operSys.contains("aix")) {
            return LINUX;
        }
        if (operSys.contains("mac")) {
            return MAC;
        }
        if (operSys.contains("sunos")) {
            return SOLARIS;
        }
        return null;
    }

    public Path resolvePath(Path rootPath, String appAcronym) {
        return rootPath.resolve(this.pathPrefix + appAcronym);
    }
}

