package tecgraf.javautils.parsers.actions;

import tecgraf.javautils.parsers.Session;
import tecgraf.javautils.parsers.symbols.Symbol;

/**
 *  a ao responsvel por gerar tokens (
 * {@link tecgraf.javautils.parsers.Token}) na sesso atual (
 * {@link tecgraf.javautils.parsers.Session}).
 */
public final class GenerateTokenAction implements TransitionAction {
  /**
   * A instncia nica.
   */
  private static GenerateTokenAction instance;

  /**
   * Obtm a instncia nica.
   * 
   * @return A instncia nica.
   */
  public static GenerateTokenAction getInstance() {
    if (instance == null) {
      instance = new GenerateTokenAction();
    }
    return instance;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void execute(final Symbol<?> symbol, final Session session) {
    session.generateToken();
  }

  /**
   * Construtor definido para impedir a criao de objetos desta classe
   * externamente.
   */
  private GenerateTokenAction() {
  }
}
