package tecgraf.javautils.parsers.exception;

import tecgraf.javautils.parsers.Session;
import tecgraf.javautils.parsers.State;

/**
 * Representa uma exceo gerada quando o autmato finito termina em um estado
 * invlido (no-final).
 */
public final class InvalidStateException extends AutomatonException {
  /**
   * O estado onde o autmato finito terminou, que no  final.
   */
  private State state;

  /**
   * Cria uma instncia com a sesso onde foi gerada a exceo e o estado onde o
   * autmato foi finalizado.
   * 
   * @param session A sesso onde foi gerada a exceo.
   * @param state O estado onde o autmato foi finalizado.
   */
  public InvalidStateException(Session session, State state) {
    super(session);
    this.state = state;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    String string = super.toString();
    return string + " - Estado: " + state.toString();
  }
}
