package tecgraf.javautils.parsers.iterators;

import tecgraf.javautils.parsers.symbols.Symbol;

/**
 * Representa um iterador de smbolos.
 */
public interface SymbolIterator {
  /**
   * Verifica se ainda existem smbolos.
   * 
   * @return true, se ainda existirem smbolos, ou false, caso contrrio.
   */
  boolean hasNext();

  /**
   * Retorna o prximo smbolo.
   * 
   * @return O prximo smbolo, ou null, caso no exista prximo.
   */
  Symbol<?> getNext();
}
