/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.parsers;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import tecgraf.javautils.parsers.Token;
import tecgraf.javautils.parsers.symbols.Symbol;

public final class Session {
    private Token currentToken = new Token();
    private List<Token> tokenList = new LinkedList<Token>();
    private boolean closed = false;

    Session() {
    }

    public void appendSymbol(Symbol<?> symbol) {
        if (symbol == null) {
            throw new IllegalArgumentException("O s\u00edmbolo n\u00e3o pode ser nulo (null).");
        }
        if (this.isClosed()) {
            throw new IllegalStateException("N\u00e3o \u00e9 poss\u00edvel inserir s\u00edmbolos em uma sess\u00e3o fechada.");
        }
        this.currentToken.addSymbol(symbol);
    }

    public void generateToken() {
        if (this.isClosed()) {
            throw new IllegalStateException("N\u00e3o \u00e9 poss\u00edvel gerar tokens em uma sess\u00e3o fechada.");
        }
        this.tokenList.add(this.currentToken);
        this.currentToken = new Token();
    }

    void close() {
        if (!this.isClosed()) {
            if (this.currentToken.getSize() > 0) {
                this.generateToken();
            }
            this.closed = true;
        }
    }

    private boolean isClosed() {
        return this.closed;
    }

    List<Token> getTokenList() {
        return Collections.unmodifiableList(this.tokenList);
    }

    public String toString() {
        return MessageFormat.format("Buffer: {0} - Tokens: {1}", this.currentToken, this.tokenList);
    }
}

