package tecgraf.javautils.parsers;

import tecgraf.javautils.parsers.actions.ErrorStateAction;

/**
 * Representa um estado de erro no autmato finito
 * {@link tecgraf.javautils.parsers.FiniteAutomaton}.
 */
public final class ErrorState extends State {
  /** A instncia nica do estado de erro. */
  private static ErrorState instance;

  /**
   * Cria o estado de erro. Esse estado no  final e possui uma ao de entrada
   * do tipo {@link ErrorStateAction}.
   */
  private ErrorState() {
    super(false, ErrorStateAction.getInstance());
  }

  /**
   * Obtm a instncia nica do estado de erro.
   * 
   * @return A instncia nica.
   */
  public static ErrorState getInstance() {
    if (instance == null) {
      instance = new ErrorState();
    }
    return instance;
  }
}
