package tecgraf.javautils.parsers.actions;

import tecgraf.javautils.parsers.Session;
import tecgraf.javautils.parsers.exception.AutomatonException;
import tecgraf.javautils.parsers.exception.ErrorStateReachedException;

/**
 *  a ao que ser executada ao entrarmos no estado de erro (
 * {@link tecgraf.javautils.parsers.ErrorState}) do autmato finito (
 * {@link tecgraf.javautils.parsers.FiniteAutomaton}).
 */
public final class ErrorStateAction implements StateAction {
  /**
   * A instncia nica.
   */
  private static ErrorStateAction instance;

  /**
   * Obtm a instncia nica.
   * 
   * @return A instncia nica.
   */
  public static ErrorStateAction getInstance() {
    if (instance == null) {
      instance = new ErrorStateAction();
    }
    return instance;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void execute(final Session session) throws AutomatonException {
    throw new ErrorStateReachedException(session);
  }

  /**
   * Construtor definido para impedir a criao de objetos desta classe
   * externamente.
   */
  private ErrorStateAction() {
  }
}
