package tecgraf.javautils.parsers.actions;

import tecgraf.javautils.parsers.Session;
import tecgraf.javautils.parsers.exception.AutomatonException;
import tecgraf.javautils.parsers.symbols.Symbol;

/**
 * Representa uma ao a ser executada pelo autmato finito (
 * {@link tecgraf.javautils.parsers.FiniteAutomaton}) ao executar uma transio
 * ( {@link tecgraf.javautils.parsers.Transition}).
 */
public interface TransitionAction {
  /**
   * Executa a ao.
   * 
   * @param symbol O smbolo que est sendo utilizado atualmente pelo autmato.
   * @param session A sesso de execuo do autmato.
   * @throws AutomatonException Caso ocorra algum erro durante a execuo da
   *         ao.
   */
  void execute(Symbol<?> symbol, Session session) throws AutomatonException;
}
