/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.parsers.csv;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import tecgraf.javautils.parsers.FiniteAutomaton;
import tecgraf.javautils.parsers.Parser;
import tecgraf.javautils.parsers.State;
import tecgraf.javautils.parsers.Token;
import tecgraf.javautils.parsers.actions.AppendAction;
import tecgraf.javautils.parsers.actions.DiscardAction;
import tecgraf.javautils.parsers.actions.GenerateTokenAction;
import tecgraf.javautils.parsers.actions.TransitionAction;
import tecgraf.javautils.parsers.exception.AutomatonException;
import tecgraf.javautils.parsers.exception.MalformedInputException;
import tecgraf.javautils.parsers.iterators.CharSymbolIterator;
import tecgraf.javautils.parsers.symbols.CharSymbol;
import tecgraf.javautils.parsers.symbols.Symbol;

public class CsvParser
extends Parser {
    public CsvParser() {
        super(new CsvFiniteAutomaton());
    }

    public final String[][] parse(InputStream inputStream, Charset charset) throws IOException, MalformedInputException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, charset);){
            String[][] stringArray = this.parse(reader);
            return stringArray;
        }
    }

    private String[][] parse(InputStreamReader reader) throws IOException, MalformedInputException {
        List<List<String>> lineList = this.createCsvRegisterList(reader);
        return this.toCsvRegisterArray(lineList);
    }

    private String[][] toCsvRegisterArray(List<List<String>> lineList) {
        String[][] fieldMatrix = new String[lineList.size()][];
        ListIterator<List<String>> lineListIterator = lineList.listIterator();
        int lineCounter = 0;
        while (lineListIterator.hasNext()) {
            List<String> fieldList = lineListIterator.next();
            fieldMatrix[lineCounter] = new String[fieldList.size()];
            ListIterator<String> fieldListIterator = fieldList.listIterator();
            int fieldCounter = 0;
            while (fieldListIterator.hasNext()) {
                fieldMatrix[lineCounter][fieldCounter] = fieldListIterator.next();
                ++fieldCounter;
            }
            ++lineCounter;
        }
        return fieldMatrix;
    }

    private List<List<String>> createCsvRegisterList(Reader reader) throws IOException, MalformedInputException {
        ArrayList<List<String>> lineList = new ArrayList<List<String>>();
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        String line = lineNumberReader.readLine();
        while (line != null) {
            List<Token> tokens;
            try {
                CharSymbolIterator symbolIterator = new CharSymbolIterator(line);
                tokens = this.parse(symbolIterator);
            }
            catch (AutomatonException e) {
                int lineNumber = lineNumberReader.getLineNumber();
                throw new MalformedInputException(lineNumber, (Throwable)e);
            }
            List<String> stringList = this.createStringList(tokens);
            lineList.add(stringList);
            line = lineNumberReader.readLine();
        }
        return lineList;
    }

    private List<String> createStringList(List<Token> tokens) {
        int size = tokens.size();
        ArrayList<String> stringList = new ArrayList<String>(size);
        for (Token token : tokens) {
            List<Symbol<?>> symbolList = token.getSymbolList();
            Iterator<Symbol<?>> symbolListIterator = symbolList.iterator();
            StringBuilder buffer = new StringBuilder();
            while (symbolListIterator.hasNext()) {
                CharSymbol symbol = (CharSymbol)symbolListIterator.next();
                buffer.append(symbol.getObject());
            }
            stringList.add(buffer.toString());
        }
        return stringList;
    }

    private static class CsvFiniteAutomaton
    extends FiniteAutomaton {
        private static final CharSymbol COMMA = new CharSymbol(',');
        private static final CharSymbol SEMICOLON = new CharSymbol(';');
        private static final CharSymbol QUOTE = new CharSymbol('\"');
        private static final CharSymbol[] SPACES = new CharSymbol[]{new CharSymbol(' '), new CharSymbol('\t'), new CharSymbol('\r'), new CharSymbol('\n')};

        private CsvFiniteAutomaton() {
            super(new State(true));
            State delimiter = this.getInitialState();
            State inWord = new State(true);
            State inQuoteWord = new State(false);
            State quoteInQuoteWord = new State(true);
            delimiter.setDefaultTransition(AppendAction.getInstance(), inWord);
            delimiter.addTransition(COMMA, (TransitionAction)GenerateTokenAction.getInstance(), delimiter);
            delimiter.addTransition(SEMICOLON, (TransitionAction)GenerateTokenAction.getInstance(), delimiter);
            delimiter.addTransition(QUOTE, (TransitionAction)DiscardAction.getInstance(), inQuoteWord);
            delimiter.addTransition(SPACES, (TransitionAction)DiscardAction.getInstance(), delimiter);
            inWord.setDefaultTransition(AppendAction.getInstance(), inWord);
            inWord.addTransition(COMMA, (TransitionAction)GenerateTokenAction.getInstance(), delimiter);
            inWord.addTransition(SEMICOLON, (TransitionAction)GenerateTokenAction.getInstance(), delimiter);
            inQuoteWord.setDefaultTransition(AppendAction.getInstance(), inQuoteWord);
            inQuoteWord.addTransition(QUOTE, (TransitionAction)DiscardAction.getInstance(), quoteInQuoteWord);
            quoteInQuoteWord.setDefaultTransition(AppendAction.getInstance(), inWord);
            quoteInQuoteWord.addTransition(QUOTE, (TransitionAction)AppendAction.getInstance(), inQuoteWord);
            quoteInQuoteWord.addTransition(COMMA, (TransitionAction)GenerateTokenAction.getInstance(), delimiter);
            quoteInQuoteWord.addTransition(SEMICOLON, (TransitionAction)GenerateTokenAction.getInstance(), delimiter);
        }
    }
}

