package tecgraf.javautils.pdfviewer.core.actions;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;

import tecgraf.javautils.pdfviewer.core.PDFCorePanel;
import tecgraf.javautils.pdfviewer.core.listeners.PDFDocumentOpenCloseListener;

/**
 * Ao bsica que fica inibida/desabilitada de acordo com a existncia de um
 * doucmento aberto.
 * 
 * @author Tecgraf
 */
abstract public class PDFAbstractDocumentOpenAwareAction extends AbstractAction
  implements PDFDocumentOpenCloseListener {

  /**
   * Painel bsico associado.
   */
  final private PDFCorePanel pdfCorePanel;

  /**
   * Construtor
   * 
   * @param pdfCorePanel painel bsico.
   * @param icon cone da ao
   */
  public PDFAbstractDocumentOpenAwareAction(PDFCorePanel pdfCorePanel, Icon icon) {
    super(null, icon);
    this.pdfCorePanel = pdfCorePanel;
    final String className = this.getClass().getSimpleName();
    putValue(Action.NAME, pdfCorePanel.getString(className + ".name"));
    putValue(Action.SHORT_DESCRIPTION, pdfCorePanel.getString(className
      + ".tooltip"));
    setEnabled(false);
  }

  /**
   * Consulta o painel bsico associado.
   * 
   * @return o painel
   */
  protected PDFCorePanel getPDFCorePanel() {
    return this.pdfCorePanel;

  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void documentOpened(PDFCorePanel source) {
    setEnabled(true);

  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void documentClosed(PDFCorePanel source) {
    setEnabled(false);
  }

}
