package tecgraf.javautils.pdfviewer.core.actions;

import java.awt.event.ActionEvent;

import tecgraf.javautils.pdfviewer.core.PDFCorePanel;
import tecgraf.javautils.pdfviewer.core.PDFCorePanel.ZoomFitPolicy;
import tecgraf.javautils.pdfviewer.viewer.PDFViewerImages;

/**
 * Ao de fit (pgina inteira).
 * 
 * @author Tecgraf
 */
public class PDFFitWholePageAction extends PDFAbstractDocumentOpenAwareAction {
  /**
   * Construtor.
   * 
   * @param pdfCorePanel
   */
  public PDFFitWholePageAction(PDFCorePanel pdfCorePanel) {
    super(pdfCorePanel, PDFViewerImages.createImageIcon("fit.whole.page.16.png"));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    getPDFCorePanel().setZoomFitPolicy(ZoomFitPolicy.WHOLE_PAGE);
  }
}