package tecgraf.javautils.pdfviewer.core.actions;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.KeyStroke;

import tecgraf.javautils.pdfviewer.core.PDFCorePanel;
import tecgraf.javautils.pdfviewer.viewer.PDFViewerImages;

/**
 * Ao de pgina posterior.
 * 
 * @author Tecgraf
 */
public class PDFNextPageAction extends PDFAbstractPageChangeAction {
  /**
   * Construtor
   * 
   * @param pdfCorePanel painel bsico.
   */
  public PDFNextPageAction(PDFCorePanel pdfCorePanel) {
    super(pdfCorePanel, PDFViewerImages.createImageIcon("next.page.16.gif"));
    final KeyStroke ks = KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_DOWN, 0);
    putValue(Action.ACCELERATOR_KEY, ks);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    final PDFCorePanel pdfPanel = getPDFCorePanel();
    if (pdfPanel.canGoToNextPage()) {
      pdfPanel.goToNextPage();
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void pageChanged(int pageNum, int totalPages) {
    setEnabled(pageNum < totalPages - 1 && totalPages > 1);
  }
}
