/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.pdfviewer.core;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PageChangeListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import tecgraf.javautils.pdfviewer.core.PDFCorePanel;
import tecgraf.javautils.pdfviewer.core.ThumbnailTableCellRenderer;
import tecgraf.javautils.pdfviewer.core.listeners.PDFDocumentOpenCloseListener;
import tecgraf.javautils.pdfviewer.core.listeners.PDFPageChangeRequestedListener;
import tecgraf.javautils.pdfviewer.core.listeners.PDFPageChangedListener;

public class PDFCoreThumbnailPanel
extends JPanel
implements PDFDocumentOpenCloseListener,
PDFPageChangedListener {
    final JScrollPane scrollPane = new JScrollPane();
    final Dimension thumbnailSize = new Dimension(0, 0);
    double pageAspectRatio = -1.0;
    final PageChangeListener thumbPageChangeListener = new PageChangeListener(){

        public void gotoPage(int pageNumber) {
            PDFCoreThumbnailPanel.this.notifyPageChangeRequestedListeners(pageNumber + 1);
        }
    };
    private List<PDFPageChangeRequestedListener> pageChangeRequestedListeners = new ArrayList<PDFPageChangeRequestedListener>();
    private final JTable table = new JTable();
    private final PDFFileTableModel pdfFileTableModel = new PDFFileTableModel();

    public PDFCoreThumbnailPanel() {
        super(new BorderLayout());
        this.setPreferredSize(new Dimension(80, 200));
        this.setupTable();
        this.add((Component)this.scrollPane, "Center");
        this.scrollPane.setViewportView(this.table);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                PDFCoreThumbnailPanel.this.calculateThumbnailSizeFromPanel();
            }
        });
    }

    protected void calculateThumbnailSizeFromPanel() {
        if (this.pageAspectRatio > 0.0) {
            int panelWidth = this.getWidth();
            int thumbWidth = panelWidth - 40;
            if (thumbWidth < 10) {
                thumbWidth = 10;
            }
            int thumbHeight = (int)((double)thumbWidth * this.pageAspectRatio);
            this.thumbnailSize.width = thumbWidth;
            this.thumbnailSize.height = thumbHeight;
            this.table.setRowHeight(thumbHeight + 50);
        }
    }

    private void setupTable() {
        this.table.setAutoCreateColumnsFromModel(false);
        TableColumn singleColumn = new TableColumn(0);
        this.table.getColumnModel().addColumn(singleColumn);
        ThumbnailTableCellRenderer renderer = new ThumbnailTableCellRenderer(this.thumbnailSize);
        this.table.getColumnModel().getColumn(0).setCellRenderer(renderer);
        this.table.setSelectionMode(0);
        this.table.setGridColor(Color.LIGHT_GRAY);
        this.table.setModel(this.pdfFileTableModel);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (event.getValueIsAdjusting()) {
                    return;
                }
                int index = PDFCoreThumbnailPanel.this.table.getSelectedRow();
                if (index > -1) {
                    PDFCoreThumbnailPanel.this.notifyPageChangeRequestedListeners(index);
                }
            }
        });
    }

    @Override
    public void documentOpened(PDFCorePanel pdfViewerPanel) {
        PDFFile pdfFile = pdfViewerPanel.getPDFFile();
        this.calculatePageAspectRatio(pdfFile);
        this.pdfFileTableModel.setPDFFile(pdfFile);
    }

    private void calculatePageAspectRatio(PDFFile pdfFile) {
        PDFPage firstPage = pdfFile.getPage(1);
        Dimension strechedPageDimension = new Dimension(100, 100);
        Dimension pageDimension = firstPage.getUnstretchedSize(strechedPageDimension.width, strechedPageDimension.height, null);
        this.pageAspectRatio = (double)pageDimension.height / (double)pageDimension.width;
        this.calculateThumbnailSizeFromPanel();
    }

    @Override
    public void documentClosed(PDFCorePanel source) {
        this.pageAspectRatio = -1.0;
        this.thumbnailSize.width = 0;
        this.thumbnailSize.height = 0;
        this.pdfFileTableModel.setPDFFile(null);
    }

    protected void notifyPageChangeRequestedListeners(int pageNumber) {
        for (PDFPageChangeRequestedListener listener : this.pageChangeRequestedListeners) {
            listener.onPageChangeRequested(pageNumber);
        }
    }

    public void addPDFPageChangeRequestListener(PDFPageChangeRequestedListener listener) {
        this.pageChangeRequestedListeners.add(listener);
    }

    @Override
    public void pageChanged(int pageNum, int totalPages) {
        if (this.table.getSelectedRow() != pageNum) {
            this.table.getSelectionModel().setSelectionInterval(pageNum, pageNum);
            this.table.scrollRectToVisible(this.table.getCellRect(pageNum, 0, true));
        }
    }

    class PDFFileTableModel
    extends DefaultTableModel {
        private PDFFile pdfFile;

        @Override
        public int getRowCount() {
            if (this.pdfFile == null) {
                return super.getRowCount();
            }
            return this.pdfFile.getNumPages();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.pdfFile.getPage(row + 1);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        void setPDFFile(PDFFile pdfFile) {
            this.pdfFile = pdfFile;
            this.fireTableDataChanged();
        }
    }
}

