/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.pdfviewer.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import tecgraf.javautils.pdfviewer.core.PDFCorePanel;
import tecgraf.javautils.pdfviewer.core.PDFDocument;
import tecgraf.javautils.pdfviewer.viewer.PDFViewerPanel;

public class PDFDialog
extends JDialog {
    private PDFViewerPanel pdfViewerPanel;

    public PDFDialog(Window owner, String title, Locale locale) {
        super(owner, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.pdfViewerPanel = new PDFViewerPanel(locale);
        this.setDefaultCloseOperation(2);
        this.addEscListener();
        JPanel buttonsPanel = this.buildButtonsPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)buttonsPanel, "South");
        this.add((Component)this.pdfViewerPanel, "Center");
    }

    public void loadDocument(PDFDocument document) {
        this.pdfViewerPanel.loadDocument(document);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.setDefaultDimension();
            this.setDefaultMode();
            this.setLocationRelativeTo(this.getOwner());
        }
        super.setVisible(visible);
    }

    private void setDefaultMode() {
        this.pdfViewerPanel.setZoomFitPolicy(PDFCorePanel.ZoomFitPolicy.WHOLE_PAGE);
    }

    private void setDefaultDimension() {
        int height;
        int width;
        this.setMinimumSize(new Dimension(300, 300));
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        Dimension docSize = this.pdfViewerPanel.getDocumentPageSize();
        if (docSize.height == 0 || docSize.width == 0) {
            width = 700;
            height = 500;
        } else {
            double docRatio = (double)docSize.width / (double)docSize.height;
            double factor = 0.8;
            if (docRatio > 1.0) {
                width = (int)Math.round((double)screenSize.width * 0.8 * 0.5);
                height = (int)Math.round((double)width / docRatio);
            } else {
                height = (int)Math.round((double)screenSize.height * 0.8);
                width = (int)Math.round((double)height * docRatio);
            }
        }
        this.setSize(new Dimension(width, height));
    }

    private String getString(String tag) {
        String prefix = this.getClass().getSimpleName();
        String realtag = prefix + "." + tag;
        String title = this.pdfViewerPanel.getString(realtag);
        return title;
    }

    private JPanel buildButtonsPanel() {
        AbstractAction closeAction = this.buildCloseAction();
        JButton closeButton = new JButton(closeAction);
        String title = this.getString("close.button");
        closeButton.setText(title);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout(1));
        buttonsPanel.add(closeButton);
        return buttonsPanel;
    }

    private void addEscListener() {
        AbstractAction closeAction = this.buildCloseAction();
        boolean mode = true;
        InputMap inputMap = this.rootPane.getInputMap(1);
        ActionMap actionMap = this.rootPane.getActionMap();
        int esc = 27;
        KeyStroke cancelStroke = KeyStroke.getKeyStroke(27, 0);
        String actionMapKey = cancelStroke.toString();
        inputMap.put(cancelStroke, actionMapKey);
        actionMap.put(actionMapKey, closeAction);
    }

    private AbstractAction buildCloseAction() {
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PDFDialog.this.setVisible(false);
                PDFDialog.this.dispose();
            }
        };
        return closeAction;
    }
}

