/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.pdfviewer.viewer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;

public class PDFViewerBundle
extends ResourceBundle {
    private final Properties properties = new Properties();

    private static String getResourcePath(Locale locale) {
        String dirName = "resources/bundles/";
        String className = PDFViewerBundle.class.getSimpleName();
        String name = locale.getLanguage() + "_" + locale.getCountry();
        String resPath = "resources/bundles/" + className + "_" + name + ".properties";
        return resPath;
    }

    private static InputStream getResourceInputStream(Locale locale) {
        String path = PDFViewerBundle.getResourcePath(locale);
        InputStream stream = PDFViewerBundle.class.getResourceAsStream(path);
        return stream;
    }

    public PDFViewerBundle(Locale locale) {
        InputStream inputStream = PDFViewerBundle.getResourceInputStream(locale);
        if (inputStream != null) {
            try {
                this.properties.load(inputStream);
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
            }
        } else {
            String className = this.getClass().getName();
            String msg = className + ": Arquivo de internacionaliza\u00e7\u00e3o n\u00e3o encontrado: " + PDFViewerBundle.getResourcePath(locale);
            System.err.println(msg);
        }
    }

    @Override
    public Object handleGetObject(String key) {
        if (this.properties.containsKey(key)) {
            return this.properties.get(key);
        }
        return "<<" + key + ">>";
    }

    @Override
    public Enumeration<String> getKeys() {
        Enumeration<String> parentKeys;
        Set<String> keys = this.properties.stringPropertyNames();
        if (this.parent != null && (parentKeys = this.parent.getKeys()) != null) {
            keys.addAll(Collections.list(parentKeys));
        }
        Enumeration<String> enumeration = Collections.enumeration(keys);
        return enumeration;
    }
}

