/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.pdfviewer.viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import tecgraf.javautils.pdfviewer.core.PDFCorePanel;
import tecgraf.javautils.pdfviewer.core.listeners.PDFDocumentOpenCloseListener;
import tecgraf.javautils.pdfviewer.core.listeners.PDFZoomChangeRequestedListener;
import tecgraf.javautils.pdfviewer.core.listeners.PDFZoomChangedListener;

public class ZoomValueComboBox
extends JPanel
implements PDFZoomChangedListener,
PDFDocumentOpenCloseListener {
    private static final int DEFAULT_HEIGHT = 26;
    final ItemListener selectionListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 1) {
                Object item = event.getItem();
                ZoomValueComboBox.this.notifyZoomChangeRequested(Double.valueOf(item.toString()));
            }
        }
    };
    final Object[] values = new Object[]{400, 300, 250, 200, 150, 125, 100, 75, 50, 25};
    final DefaultComboBoxModel comboModel = new DefaultComboBoxModel<Object>(this.values);
    final JComboBox comboBox = new JComboBox(this.comboModel);
    final ListCellRenderer percentCellRenderer = new PercentageListCellRenderer();
    final PercentageComboEditor comboEditor = new PercentageComboEditor();
    final List<PDFZoomChangeRequestedListener> zoomChangeRequestListeners = new ArrayList<PDFZoomChangeRequestedListener>();

    public ZoomValueComboBox() {
        super(new BorderLayout());
        this.setEnabled(false);
        this.setPreferredSize(new Dimension(75, 26));
        this.setMinimumSize(new Dimension(40, 26));
        this.setMaximumSize(new Dimension(80, 26));
        this.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.comboBox.setMaximumSize(new Dimension(80, 26));
        this.comboBox.setPreferredSize(new Dimension(75, 26));
        this.comboBox.setMinimumSize(new Dimension(40, 26));
        this.add((Component)this.comboBox, "Center");
        this.comboBox.setEditable(true);
        this.comboBox.setEditor(this.comboEditor);
        this.comboBox.setRenderer(this.percentCellRenderer);
        this.comboBox.addItemListener(this.selectionListener);
    }

    @Override
    public void zoomChanged(double zoomPercentage) {
        this.comboBox.removeItemListener(this.selectionListener);
        this.comboBox.getModel().setSelectedItem((int)zoomPercentage);
        this.comboBox.addItemListener(this.selectionListener);
    }

    @Override
    public void documentOpened(PDFCorePanel pdfViewerPanel) {
        this.setEnabled(true);
    }

    @Override
    public void documentClosed(PDFCorePanel source) {
        this.setEnabled(false);
    }

    public void addPDFZoomChangeRequestedListener(PDFZoomChangeRequestedListener listener) {
        this.zoomChangeRequestListeners.add(listener);
    }

    public void removePDFZoomChangeRequestedListener(PDFZoomChangeRequestedListener listener) {
        this.zoomChangeRequestListeners.remove(listener);
    }

    protected void notifyZoomChangeRequested(double percentage) {
        for (PDFZoomChangeRequestedListener listener : this.zoomChangeRequestListeners) {
            listener.zoomChangeRequested(percentage);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.comboBox.setEnabled(enabled);
        this.comboEditor.setEnabled(enabled);
    }

    class PercentageComboEditor
    extends BasicComboBoxEditor {
        final JPanel compositeEditor = new JPanel();
        final JLabel pctLabel = new JLabel("%");

        public PercentageComboEditor() {
            this.compositeEditor.setLayout(new BorderLayout());
            this.pctLabel.setMinimumSize(new Dimension(25, 26));
            this.pctLabel.setOpaque(true);
            this.pctLabel.setBackground(this.editor.getBackground());
            this.compositeEditor.add((Component)this.editor, "Center");
            this.compositeEditor.add((Component)this.pctLabel, "East");
            this.editor.setHorizontalAlignment(4);
            this.editor.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    char c = e.getKeyChar();
                    if (PercentageComboEditor.this.getEditor().getText().length() > 3 || !Character.isDigit(c) && c != '\b' && c != '\u007f') {
                        e.consume();
                    }
                }
            });
        }

        @Override
        protected JTextField createEditorComponent() {
            JTextField editor = new JTextField();
            editor.setBorder(null);
            return editor;
        }

        @Override
        public Component getEditorComponent() {
            return this.compositeEditor;
        }

        JTextField getEditor() {
            return this.editor;
        }

        void setEnabled(boolean enabled) {
            this.editor.setEnabled(enabled);
            this.pctLabel.setEnabled(enabled);
        }
    }

    class PercentageListCellRenderer
    extends DefaultListCellRenderer {
        PercentageListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String zoom = value.toString();
            label.setText(zoom + "%");
            label.setHorizontalAlignment(0);
            return label;
        }
    }
}

