package tecgraf.javautils.sparkserver.standard;

import tecgraf.javautils.sparkserver.core.JuIEndpoint;
import tecgraf.javautils.sparkserver.core.JuIFunction;

public class JuEndpoint implements JuIEndpoint {

  final public JuVerb verb;
  final public String path;
  final public JuRoute route;

  public <T> JuEndpoint(JuVerb verb, String path, JuIFunction<T> function) {
    this(verb, path, new JuRoute(function));
  }

  public JuEndpoint(JuVerb verb, String path, JuRoute route) {
    if (verb == null) {
      throw new IllegalArgumentException("null verb not allowed!");
    }
    if (path == null) {
      throw new IllegalArgumentException("null path not allowed!");
    }
    if (route == null) {
      throw new IllegalArgumentException("null route not allowed!");
    }
    this.verb = verb;
    this.path = path;
    this.route = route;
  }

  @Override
  public JuVerb getVerb() {
    return verb;
  }

  @Override
  public String getPath() {
    return path;
  }

  @Override
  public JuRoute getRoute() {
    return route;
  }
}
