package tecgraf.javautils.sparkserver.demo;

import javax.ws.rs.GET;
import javax.ws.rs.Path;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;

import tecgraf.javautils.sparkserver.core.JuIFunction;
import tecgraf.javautils.sparkserver.standard.JuVerb;
import tecgraf.javautils.sparkserver.exceptions.JuAuthorizationException;
import tecgraf.javautils.sparkserver.standard.JuController;
import tecgraf.javautils.sparkserver.utils.JuResponseUtilities;

@Api
public class PingController extends JuController {

  /**
   * Construtor
   */
  protected PingController() {
    addWebSocket("pingpong", PingWebSocket.class);
    addEndpoint(JuVerb.GET, "ping", getOk());
    addEndpoint(JuVerb.GET, "pong", getNotOk());
  }

  @GET
  @Path("ping")
  @ApiOperation(value = "ping")
  @ApiResponse(code = 200, message = "Sempre OK!")
  private JuIFunction<String> getOk() {
    return (req, res) -> JuResponseUtilities.setResponseAsText(res, 200, "ok");
  }

  @GET
  @Path("pong")
  @ApiOperation(value = "pong")
  @ApiResponse(code = 404, message = "Sempre NOK!")
  private JuIFunction<String> getNotOk() {
    return (req, res) -> {
      throw new JuAuthorizationException("NOT OK as expected!");
    };
  }
}
