package tecgraf.javautils.sparkserver.utils;

public class JuStringUtilities {

  /**
   * Converte uma string em um long
   * @param txt texto
   * @return long ou null (se não for possível)
   * @throws IllegalArgumentException se o texto for nulo.
   */
  static public Long longOrNull(String txt) {
    if (txt == null) {
      throw new IllegalArgumentException("Invalid null to convertion!");
    }
    try {
      final Long l = Long.parseLong(txt.trim());
      return l;
    }
    catch (NumberFormatException nfe) {
      return null;
    }
  }

  /**
   * Converte uma string em um double
   * @param txt texto
   * @return long ou null (se não for possível)
   * @throws IllegalArgumentException se o texto for nulo.
   */
  static public Double doubleOrNull(String txt) {
    if (txt == null) {
      throw new IllegalArgumentException("Invalid null to conversion!");
    }
    try {
      final double d = Double.parseDouble(txt.trim());
      return d;
    }
    catch (NumberFormatException nfe) {
      return null;
    }
  }

}
