package tecgraf.javautils.sparkserver.demo;

import tecgraf.javautils.sparkserver.demo.echo.EchoController;
import tecgraf.javautils.sparkserver.demo.ping.PingController;
import tecgraf.javautils.sparkserver.standard.JuServer;

public class DemoServer {

  public static void main(String[] args) {
    final JuServer server = JuServer.getInstance();
    final PingController pingController = new PingController();
    final EchoController echoController = new EchoController();
    server.addController(pingController);
    server.addController(echoController);
    server.setHostPort(9999);
    server.setName("JuSpark Server Demo");
    server.setDescription("Servidor de testes da biblioteca");
    try {
      server.start();
    }
    catch (Exception e) {
      System.err.println("Erro de start!");
      e.printStackTrace();
      System.exit(-1);
    }
  }

}
