package tecgraf.javautils.sparkserver.standard;

import java.util.HashMap;

import tecgraf.javautils.sparkserver.core.JuIResponse;

public class JuResponse implements JuIResponse {

  private final int code;
  private String description;
  private HashMap<String, Object> examples = new HashMap<>();

  public JuResponse(int code) {
    this.code = code;
  }

  @Override
  public int getStatusCode() {
    return code;
  }

  @Override
  public String getDescription() {
    return description == null ? "" : description;
  }

  @Override
  public JuIResponse setDescription(String description) {
    this.description = description;
    return this;
  }

  @Override
  public JuIResponse addExampleAsString(String name, Object value) {
    this.examples.put(name, value);
    return this;
  }

  @Override
  public HashMap<String, Object> getExamplesAsString() {
    return examples;
  }
}
