package tecgraf.javautils.sparkserver.utils;

import java.io.IOException;

import spark.Response;

public class JuResponseUtilities {

  public static <T> String setResponseAsJson(Response response, int statusCode, T data) throws IOException {
    final String jsonString = JuSparkUtilities.objectToJson(data);
    response.type("application/json");
    response.body(jsonString);
    response.status(statusCode);
    return jsonString;
  }

  public static <T> T setResponseAsJsonObject(Response response, int statusCode, T data) throws IOException {
    final String jsonString = JuSparkUtilities.objectToJson(data);
    response.type("application/json");
    response.body(jsonString);
    response.status(statusCode);
    return data;
  }


  public static String setResponseAsText(Response response, int statusCode, String message) {
    response.type("text/plain");
    response.body(message);
    response.status(statusCode);
    return message;
  }
}
