package tecgraf.javautils.sparkserver.library.standard;

import tecgraf.javautils.sparkserver.library.core.JuIParameter;

public class JuParameter implements JuIParameter {

  private String name;
  private String description;
  private String exampleAsString;
  private Class<?> classValue;

  public JuParameter(String name) {
    this.name = name;
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public String getDescription() {
    return description;
  }

  @Override
  public Class<?> getClassValue() {
    return classValue;
  }

  @Override
  public String getExampleAsString() {
    return exampleAsString;
  }
  protected JuIParameter setDescription(String description) {
    this.description = (description == null ? "-" : description.trim());
    return this;
  }

  protected JuIParameter setClassValue(Class<?> classValue) {
    this.classValue = (classValue == null ? String.class : classValue);
    return this;
  }

  protected JuIParameter setExampleAsString(String exampleAsString) {
    this.exampleAsString = (exampleAsString == null ? "-" : exampleAsString.trim());
    return this;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final JuParameter that = (JuParameter) o;
    return name.equals(that.name);
  }

  @Override
  public int hashCode() {
    return name.hashCode();
  }
}
