package tecgraf.javautils.sparkserver.library.utils;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;

public class JuSparkUtilities {

  public static <T> Class<List<T>> getListClassOf(Class<T> clazz) {
    final List<T> array = new ArrayList<>();
    final Class<List<T>> cls = (Class<List<T>>)array.getClass();
    return cls;
  }

  public static <T> T jsonToObject(String json, Class<T> clazz) throws IOException {
    final ObjectMapper objectMapper = new ObjectMapper();
    return objectMapper.readValue(json, clazz);
  }

  public static JsonNode jsonToNode(String json) throws IOException {
    final ObjectMapper objectMapper = new ObjectMapper();
    return objectMapper.readTree(json);
  }

  public static String nodeToJson(JsonNode node) throws IOException {
    final ObjectMapper mapper = new ObjectMapper();
    mapper.enable(SerializationFeature.INDENT_OUTPUT);
    final StringWriter sw = new StringWriter();
    mapper.writeValue(sw, node);
    return sw.toString();
  }

  public static <T> String objectToJson(T data) throws IOException {
    final ObjectMapper mapper = new ObjectMapper();
    mapper.enable(SerializationFeature.INDENT_OUTPUT);
    final StringWriter sw = new StringWriter();
    mapper.writeValue(sw, data);
    return sw.toString();
  }

}
