/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.sparkserver.demo.echo;

import java.util.ArrayList;
import java.util.List;
import tecgraf.javautils.sparkserver.demo.echo.EchoDate;
import tecgraf.javautils.sparkserver.demo.echo.EchoOutput;
import tecgraf.javautils.sparkserver.library.core.JuIEndpoint;
import tecgraf.javautils.sparkserver.library.core.JuIFunction;
import tecgraf.javautils.sparkserver.library.exceptions.JuBadRequestException;
import tecgraf.javautils.sparkserver.library.standard.JuController;
import tecgraf.javautils.sparkserver.library.standard.JuEndpoint;
import tecgraf.javautils.sparkserver.library.standard.JuRoute;
import tecgraf.javautils.sparkserver.library.standard.JuVerb;
import tecgraf.javautils.sparkserver.library.utils.JuRequestUtilities;
import tecgraf.javautils.sparkserver.library.utils.JuResponseUtilities;
import tecgraf.javautils.sparkserver.library.utils.JuSparkUtilities;
import tecgraf.javautils.sparkserver.library.utils.JuStringUtilities;

public class EchoController
extends JuController {
    public EchoController() {
        this.addEndpoint(this.getDateEndpoint());
        this.addEndpoint(this.getDatesEndpoint());
        this.addEndpoint(this.getEchoEndpoint());
        this.setName("Echo");
        this.setDescription("Controlador echo com exemplos");
    }

    private JuIEndpoint getDatesEndpoint() {
        ArrayList<EchoDate> dates = new ArrayList<EchoDate>();
        EchoDate date1 = new EchoDate(21, 4, 1500);
        EchoDate date2 = new EchoDate(4, 6, 1971);
        EchoDate date3 = new EchoDate(25, 12, 2020);
        dates.add(date1);
        dates.add(date2);
        dates.add(date3);
        JuIFunction<List> function = (req, res) -> JuResponseUtilities.setResponseAsJsonObject(res, 200, dates);
        Class<List<EchoDate>> listClass = JuSparkUtilities.getListClassOf(EchoDate.class);
        JuRoute<List<EchoDate>> route = new JuRoute<List<EchoDate>>(function, listClass, EchoDate.class);
        JuEndpoint endpoint = new JuEndpoint(JuVerb.GET, "dates", route);
        endpoint.setName("dates").setDescription("Returns important dates");
        endpoint.addResponse(200).setDescription("Same object date").addExampleAsString("Clinio", dates);
        endpoint.addResponse(404).setDescription("Date not found!");
        return endpoint;
    }

    private JuIEndpoint getDateEndpoint() {
        JuIFunction<EchoDate> function = (req, res) -> {
            String _day = JuRequestUtilities.getRequestParameter(req, "day", true);
            String _month = JuRequestUtilities.getRequestParameter(req, "month", true);
            String _year = JuRequestUtilities.getRequestParameter(req, "year", true);
            if (_day == null || _month == null || _year == null) {
                throw new JuBadRequestException("not enough parameters!");
            }
            Long day = JuStringUtilities.longOrNull(_day);
            Long month = JuStringUtilities.longOrNull(_month);
            Long year = JuStringUtilities.longOrNull(_year);
            if (day == null || month == null || year == null) {
                throw new JuBadRequestException("not valid parameters!");
            }
            int d = day.intValue();
            int m = month.intValue();
            int y = year.intValue();
            EchoDate date = new EchoDate(d, m, y);
            return JuResponseUtilities.setResponseAsJsonObject(res, 200, date);
        };
        JuRoute<EchoDate> route = new JuRoute<EchoDate>(function, EchoDate.class);
        JuEndpoint endpoint = new JuEndpoint(JuVerb.GET, "date/:day/:month/:year", route);
        endpoint.setName("date").setDescription("Returns a structure data base on path parameters");
        endpoint.addPathParameter("day").setDescription("day of year").setExampleAsString("31").setClassValue(Integer.class);
        endpoint.addPathParameter("month").setDescription("month of year").setExampleAsString("31").setClassValue(Integer.class);
        endpoint.addPathParameter("year").setDescription("year").setExampleAsString("1970").setClassValue(Integer.class);
        endpoint.addResponse(200).setDescription("Same object date").addExampleAsString("Clinio", new EchoDate(4, 6, 1971));
        endpoint.addResponse(404).setDescription("Date not found!");
        return endpoint;
    }

    private JuIEndpoint getEchoEndpoint() {
        JuIFunction<EchoOutput> function = (req, res) -> {
            String input = JuRequestUtilities.getQueryParameter(req, "input", false);
            input = input == null ? "no-input" : input;
            EchoOutput output = new EchoOutput(input);
            return JuResponseUtilities.setResponseAsJsonObject(res, 200, output);
        };
        JuRoute<EchoOutput> route = new JuRoute<EchoOutput>(function, EchoOutput.class);
        JuEndpoint endpoint = new JuEndpoint(JuVerb.GET, "echo", route);
        endpoint.setName("echo").setDescription("Returns echo string based on query parameter");
        endpoint.addQueryParameter("input").setRequired(false).setClassValue(String.class).setDescription("Input").setExampleAsString("yada yada");
        endpoint.addResponse(200).setDescription("Blah").addExampleAsString("blah", new EchoOutput("blah blah"));
        return endpoint;
    }
}

