/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.sparkserver.library.standard;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tecgraf.javautils.sparkserver.library.core.JuIController;
import tecgraf.javautils.sparkserver.library.core.JuIEndpoint;
import tecgraf.javautils.sparkserver.library.core.JuIFunction;
import tecgraf.javautils.sparkserver.library.core.JuIWebSocket;
import tecgraf.javautils.sparkserver.library.standard.JuEndpoint;
import tecgraf.javautils.sparkserver.library.standard.JuRoute;
import tecgraf.javautils.sparkserver.library.standard.JuVerb;
import tecgraf.javautils.sparkserver.library.standard.JuWebSocket;
import tecgraf.javautils.sparkserver.library.standard.JuWebSocketClass;

public class JuController
implements JuIController {
    private final List<JuIEndpoint> endpoints = new ArrayList<JuIEndpoint>();
    private final List<JuIWebSocket> websockets = new ArrayList<JuIWebSocket>();
    private String pathPrefix;
    private String description;
    private String name;

    protected JuController() {
    }

    @Override
    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public void setPathPrefix(String pathPrefix) {
        if (pathPrefix != null && pathPrefix.indexOf("/") != -1) {
            throw new IllegalArgumentException("path-prefix cannot contain '/'");
        }
        this.pathPrefix = pathPrefix;
    }

    @Override
    public Stream<JuIEndpoint> getEndpoints() {
        return this.endpoints.stream();
    }

    @Override
    public Stream<JuIWebSocket> getWebSockets() {
        return this.websockets.stream();
    }

    @Override
    public String getName() {
        return this.name == null ? this.getClass().getSimpleName() : this.name.trim();
    }

    @Override
    public String getDescription() {
        return this.description == null ? "" : this.description.trim();
    }

    @Override
    public JuIController setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public JuIController setDescription(String description) {
        this.description = description;
        return this;
    }

    protected <T> JuIEndpoint addEndpoint(JuIEndpoint endpoint) {
        this.endpoints.add(endpoint);
        return endpoint;
    }

    protected <T> JuIEndpoint addEndpoint(JuVerb verb, String path, JuRoute<T> route) {
        JuEndpoint ep = new JuEndpoint(verb, path, route);
        return this.addEndpoint(ep);
    }

    protected <T> JuIEndpoint addEndpoint(JuVerb verb, String path, JuIFunction<T> function, Class<T> responseClass) {
        JuEndpoint ep = new JuEndpoint(verb, path, function, responseClass);
        this.endpoints.add(ep);
        return this.addEndpoint(ep);
    }

    protected <T> JuIWebSocket addWebSocket(String path, Class<? extends JuWebSocketClass> clazz) {
        String realPath = this.getRealPath(path);
        JuWebSocket websocket = new JuWebSocket(realPath, clazz);
        this.websockets.add(websocket);
        return websocket;
    }

    protected Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    private String getRealPath(String path) {
        boolean noPrefix;
        String prefix = this.getPathPrefix();
        boolean noPath = path == null || path.trim().isEmpty();
        boolean bl = noPrefix = prefix == null || prefix.trim().isEmpty();
        if (noPath && noPrefix) {
            return "/";
        }
        if (noPath) {
            return prefix;
        }
        if (noPrefix) {
            return path;
        }
        return prefix + "/" + path;
    }
}

