/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.sparkserver.library.swagger;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.models.Swagger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tecgraf.javautils.sparkserver.library.swagger.JuSwaggerTheme;

public class JuSwaggerWriter {
    private static final Logger logger = LoggerFactory.getLogger(JuSwaggerWriter.class);

    public String prepareUi(Swagger swagger, JuSwaggerTheme theme) throws IOException {
        String baseDirectory = this.getBaseDirectory();
        String outputDirectory = this.getOutputDirectory(baseDirectory);
        logger.info("swagger ui local directory: " + outputDirectory);
        logger.info("swagger ui base directory: " + baseDirectory);
        this.deleteDirectory(outputDirectory);
        this.createDirectory(outputDirectory);
        this.unzipFilesTo(outputDirectory);
        this.generateSpecFile(outputDirectory, swagger);
        this.applyTheme(outputDirectory, theme);
        return baseDirectory;
    }

    private void generateSpecFile(String uiFolder, Swagger swagger) throws IOException {
        String fileName = "swagger-spec.js";
        String pathName = uiFolder + "/swagger-spec.js";
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        String jsonText = mapper.writeValueAsString((Object)swagger);
        String jsText = "window.swaggerSpec=" + jsonText;
        File file = new File(pathName);
        file.delete();
        try (PrintWriter out = new PrintWriter(pathName);){
            out.println(jsText);
        }
        logger.info("swagger definitions saved to '" + pathName);
    }

    private void unzipFilesTo(String uiFolder) throws IOException {
        ZipEntry entry;
        InputStream is = this.getClass().getResourceAsStream("/swagger-ui.zip");
        ZipInputStream zis = new ZipInputStream(is);
        byte[] buffer = new byte[2048];
        Path outDirPath = Paths.get(uiFolder, new String[0]);
        while ((entry = zis.getNextEntry()) != null) {
            String name = entry.getName();
            Path outPath = outDirPath.resolve(name);
            File outFile = outPath.toFile();
            try (FileOutputStream fos = new FileOutputStream(outFile);
                 BufferedOutputStream bos = new BufferedOutputStream(fos, buffer.length);){
                int len;
                while ((len = zis.read(buffer)) > 0) {
                    bos.write(buffer, 0, len);
                }
            }
        }
    }

    private void applyTheme(String uiFolder, JuSwaggerTheme theme) throws IOException {
        String themeCss = this.readFile(uiFolder, theme.getValue() + ".css", StandardCharsets.UTF_8);
        this.saveFile(uiFolder, "swagger-ui.css", themeCss);
        logger.info("css theme successfully applied: " + theme);
    }

    private String readFile(String uiFolder, String name, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(uiFolder, name));
        return new String(encoded, encoding);
    }

    private void saveFile(String uiFolder, String fileName, String content) throws IOException {
        File file = new File(uiFolder, fileName);
        file.delete();
        FileWriter f2 = new FileWriter(file, false);
        f2.write(content);
        f2.close();
        logger.debug("Spark-Swagger: Swagger UI file " + fileName + " successfully saved");
    }

    public String getOutputDirectory(String baseDirectory) {
        return baseDirectory + "/swagger-ui/";
    }

    private String getBaseDirectory() {
        String name = UUID.randomUUID().toString();
        String tmpDir = "/tmp/" + name + "/";
        return tmpDir;
    }

    public void createDirectory(String pathName) throws IOException {
        Path path = Paths.get(pathName, new String[0]);
        Files.createDirectories(path, new FileAttribute[0]);
    }

    private boolean deleteDirectory(String pathName) {
        File directoryToBeDeleted = new File(pathName);
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                this.deleteDirectory(file.getPath());
            }
        }
        return directoryToBeDeleted.delete();
    }
}

