package tecgraf.javautils.version;

import java.util.ArrayList;
import java.util.List;

/**
 * Utilitrio para ajuda de controle entre verses.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class VersionUtils {

  /** Nmero mximo permitido de transies (por segurana). */
  public static final int MAX_VERSION_LIST = 500;

  /**
   * Retorna a lista de verses existentes do recurso entre duas verses.
   * 
   * @param finder objeto de busca do recurso em uma verso.
   * @param fromVersion verso inicial
   * @param toVersion verso final
   * @return lista
   */
  static public List<VersionNumber> getExistantVersionsList(
    VersionNumberFinder finder, VersionNumber fromVersion,
    VersionNumber toVersion) {
    List<VersionNumber> list = new ArrayList<VersionNumber>();
    VersionNumber version = fromVersion.clone();
    while (version.isValid()) {
      boolean toVersionReached = (version.compareTo(toVersion) > 0);
      if (toVersionReached) {
        break;
      }
      boolean isPresent = finder.hasVersionNumber(version);
      if (isPresent) {
        if (list.size() > MAX_VERSION_LIST) {
          String fmt = "Max of versions (%d) transitions reached for %s!";
          String err = String.format(fmt, MAX_VERSION_LIST, version);
          throw new IllegalStateException(err);
        }
        VersionNumber newVersion = version.clone();
        newVersion.freeze();
        list.add(newVersion);
      }
      version.add();
    }
    return list;
  }

  /**
   * Monta uma lista de transies de verses.
   * 
   * @param versionsList lista de verses
   * @return lista de transies
   */
  static public List<VersionNumberTransition> getTransitionPairsList(
    List<VersionNumber> versionsList) {
    List<VersionNumberTransition> list =
      new ArrayList<VersionNumberTransition>();
    if (versionsList == null) {
      return list;
    }
    int size = versionsList.size();
    if (size < 2) {
      return list;
    }

    for (int i = 0; i < size - 1; i++) {
      VersionNumber fromVersion = versionsList.get(i);
      VersionNumber toVersion = versionsList.get(i + 1);
      VersionNumberTransition pair =
        new VersionNumberTransition(fromVersion, toVersion);
      list.add(pair);
    }
    return list;
  }
}
